/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.sal.confluence.lifecycle.ServiceExecutionStrategy;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Function;
import org.osgi.framework.ServiceReference;

public class ServiceExecutionStrategyComposite<S>
implements ServiceExecutionStrategy<S> {
    private final ServiceExecutionStrategy<S>[] executionStrategies;

    public ServiceExecutionStrategyComposite(ServiceExecutionStrategy<S>[] executionStrategies) {
        this.executionStrategies = executionStrategies;
    }

    @Override
    public boolean add(ServiceReference serviceReference, Tenant tenant, Function<S, ?> serviceCallback) {
        for (ServiceExecutionStrategy<S> executionStrategy : this.executionStrategies) {
            if (!executionStrategy.add(serviceReference, tenant, serviceCallback)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trigger() {
        for (ServiceExecutionStrategy<S> executionStrategy : this.executionStrategies) {
            executionStrategy.trigger();
        }
    }
}

