/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.sal.confluence.lifecycle.ExecutionStrategyTemplate;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceReference;

public class SequentialExecutionStrategy<S>
extends ExecutionStrategyTemplate<S> {
    private final ExecutorService executorService;

    public SequentialExecutionStrategy(Function<ServiceReference, Option<ModuleCompleteKey>> moduleReferenceParser, ExecutorService executorService) {
        super(moduleReferenceParser);
        this.executorService = executorService;
    }

    @Override
    public void trigger() {
        for (Callable callable : this.serviceExecutions) {
            try {
                this.executorService.submit(callable).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    Throwables.propagate((Throwable)e.getCause());
                }
                Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    protected String getDescription() {
        return "sequential";
    }
}

