/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.sal.confluence.lifecycle.ServiceExecutionStrategy;
import com.atlassian.sal.confluence.lifecycle.StaticServiceExecution;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Function;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.ServiceReference;

public abstract class ExecutionStrategyTemplate<S>
implements ServiceExecutionStrategy<S> {
    protected final Function<ServiceReference, Option<ModuleCompleteKey>> moduleReferenceParser;
    protected final Queue<Callable> serviceExecutions = new ConcurrentLinkedQueue<Callable>();

    protected ExecutionStrategyTemplate(Function<ServiceReference, Option<ModuleCompleteKey>> moduleReferenceParser) {
        this.moduleReferenceParser = moduleReferenceParser;
    }

    @Override
    public boolean add(ServiceReference serviceReference, Tenant tenant, Function<S, ?> serviceCallback) {
        return this.serviceExecutions.add(this.createServiceExecution(serviceReference, tenant, serviceCallback));
    }

    protected Callable createServiceExecution(ServiceReference serviceReference, final Tenant tenant, Function<S, ?> serviceCallback) {
        return new StaticServiceExecution(serviceReference, serviceCallback){

            @Override
            protected String serviceReferenceToString() {
                StringBuilder sb = new StringBuilder();
                sb.append(ExecutionStrategyTemplate.this.getDescription());
                sb.append(" ");
                sb.append(tenant.toString());
                Option maybeModuleReference = (Option)ExecutionStrategyTemplate.this.moduleReferenceParser.apply((Object)this.serviceReference);
                if (maybeModuleReference.isDefined()) {
                    sb.append(" ");
                    sb.append(maybeModuleReference.get());
                }
                sb.append(" ");
                sb.append(super.serviceReferenceToString());
                return sb.toString();
            }
        };
    }

    protected String getDescription() {
        return this.getClass().getSimpleName();
    }
}

