/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.resources;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/label/{labelId}/watches")
@Produces(value={"application/json;charset=UTF-8"})
public class LabelWatchesResource {
    private final NotificationManager notificationManager;
    private final LabelManager labelManager;

    private LabelWatchesResource() {
        this.notificationManager = null;
        this.labelManager = null;
    }

    public LabelWatchesResource(NotificationManager notificationManager, LabelManager labelManager) {
        this.notificationManager = notificationManager;
        this.labelManager = labelManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLabelWatches(@PathParam(value="labelId") long labelId) {
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        List notifications = this.notificationManager.getNotificationsByLabel(label);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("count", Integer.valueOf(notifications.size()));
        LinkedList<Map<String, String>> data = new LinkedList<Map<String, String>>();
        for (Notification notification : notifications) {
            if (notification.getReceiver() == null) continue;
            data.add(Collections.singletonMap("key", notification.getReceiver().getKey().getStringValue()));
        }
        result.put("data", data);
        return Response.ok(result).build();
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response addLabelWatch(@PathParam(value="labelId") long labelId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        this.notificationManager.addLabelNotification((User)user, label);
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response removeLabelWatch(@PathParam(value="labelId") long labelId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        this.notificationManager.removeLabelNotification((User)user, label);
        return Response.ok().build();
    }
}

