/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.resources;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.search.ReIndexTask;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.lucene.ReIndexOption;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;

@Path(value="/index")
@Produces(value={"application/json;charset=UTF-8"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class IndexResource
extends AbstractResource {
    private final ConfluenceIndexManager indexManager;

    private IndexResource() {
        this.indexManager = null;
    }

    public IndexResource(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    @Path(value="/reindex")
    @Consumes(value={"application/json"})
    @POST
    @ResourceFilters(value={SysadminOnlyResourceFilter.class})
    public Response reIndex(@QueryParam(value="option") List<String> options) {
        HashSet<ReIndexOption> reIndexOptions = new HashSet<ReIndexOption>();
        for (String option : options) {
            if (StringUtils.isBlank((CharSequence)option)) continue;
            try {
                reIndexOptions.add(ReIndexOption.valueOf((String)option));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        ReIndexTask indexingTask = this.indexManager.reIndex(reIndexOptions.isEmpty() ? EnumSet.allOf(ReIndexOption.class) : reIndexOptions);
        return Response.ok((Object)ReIndexTaskEntity.from(indexingTask)).build();
    }

    @Path(value="/reindex")
    @GET
    public Response reIndexStatus() {
        ReIndexTask indexingTask = this.indexManager.getLastReindexingTask();
        if (indexingTask != null) {
            return Response.ok((Object)ReIndexTaskEntity.from(indexingTask)).build();
        }
        return Response.ok((Object)"Reindex status not available.").build();
    }

    @Path(value="/unindex")
    @Consumes(value={"application/json"})
    @POST
    @ResourceFilters(value={SysadminOnlyResourceFilter.class})
    public Response unIndexAll() {
        this.indexManager.unIndexAll();
        return Response.ok().build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class ReIndexTaskEntity {
        private boolean finished;
        private int percentageComplete;
        private String elapsedTime;
        private String remainingTime;
        private int jobID;

        private ReIndexTaskEntity() {
        }

        static ReIndexTaskEntity from(ReIndexTask reIndexTask) {
            ReIndexTaskEntity entity = new ReIndexTaskEntity();
            entity.finished = reIndexTask.isFinishedReindexing();
            entity.percentageComplete = reIndexTask.getProgress().getPercentComplete();
            entity.elapsedTime = reIndexTask.getCompactElapsedTime();
            entity.jobID = reIndexTask.getJobID();
            return entity;
        }
    }
}

