/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.entities;

import com.atlassian.confluence.setup.BuildInformation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="buildInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BuildInfoEntity {
    @XmlAttribute
    private String versionNumber;
    @XmlAttribute
    private Date buildDate;
    @XmlAttribute
    private String buildTimestamp;
    @XmlAttribute
    private String buildNumber;
    @XmlAttribute
    private String bambooBuildNumber;
    @XmlAttribute
    private String revisionNumber;

    public BuildInfoEntity() {
    }

    public BuildInfoEntity(String versionNumber, Date buildDate, String buildNumber, String bambooBuildNumber, String revisionNumber) {
        this.versionNumber = versionNumber;
        this.buildDate = buildDate;
        this.buildNumber = buildNumber;
        this.bambooBuildNumber = bambooBuildNumber;
        this.revisionNumber = revisionNumber;
    }

    public BuildInfoEntity(BuildInformation instance) {
        this(instance.getVersionNumber(), instance.getBuildDate(), instance.getBuildNumber(), instance.getBambooBuildNumber(), instance.getGitCommitHash());
        this.buildTimestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH).format(instance.getBuildTimestamp());
    }
}

