/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.requiredhealthchecks;

import com.atlassian.confluence.plugins.healthcheck.requiredhealthchecks.RequiredHealthChecksSupplier;
import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.Set;

public final class RequiredHealthChecksEnabledCheck
implements HealthCheck {
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory(Application.Confluence, "");
    private final Set<String> requiredHealthCheckModuleKeys;
    private final PluginAccessor pluginAccessor;

    public RequiredHealthChecksEnabledCheck(PluginAccessor pluginAccessor, RequiredHealthChecksSupplier requiredHealthChecksSupplier) {
        this.pluginAccessor = pluginAccessor;
        this.requiredHealthCheckModuleKeys = requiredHealthChecksSupplier.getRequiredHealthCheckModuleKeys();
    }

    public HealthStatus check() {
        LinkedList<String> missingChecks = new LinkedList<String>();
        for (String fullModuleKey : this.requiredHealthCheckModuleKeys) {
            try {
                if (this.isHealthCheckEnabled(fullModuleKey)) continue;
                missingChecks.add(fullModuleKey + " (missing or disabled)");
            }
            catch (RuntimeException e) {
                missingChecks.add(fullModuleKey + " (error: " + e.getMessage() + ")");
            }
        }
        if (!missingChecks.isEmpty()) {
            return this.healthStatusFactory.failed("Some required health checks are not enabled: " + Sets.newTreeSet(missingChecks));
        }
        return this.healthStatusFactory.healthy();
    }

    private boolean isHealthCheckEnabled(String fullModuleKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(fullModuleKey);
        if (moduleDescriptor == null) {
            return false;
        }
        Object module = moduleDescriptor.getModule();
        if (!(module instanceof HealthCheck)) {
            throw new RuntimeException("Module is not an instance of " + HealthCheck.class.getName());
        }
        return true;
    }
}

