AJS.toInit(function ($) {
    var pageId = AJS.Meta.get("page-id"),
        restrictedPage = $("#page-restricted-container"),
        requestAccessUser = AJS.Meta.get("remote-user"),
        requestAccessButton = $("#page-restricted-container button");

    if (restrictedPage.length) {
        // Hiding breadcrumbs + title of the 'No Permissions' page
        $("#breadcrumbs").hide();
        $("#title-text.with-breadcrumbs").hide();

        if (requestAccessButton.length) {
            // Trigger an event for views which have the request access button, so that we can find out
            // how many users see this page but don't use the feature
            AJS.trigger('analyticsEvent', {name: 'confluence.request.access.plugin.request.access.to.page.view',
                data: {pageId: pageId, requestAccessUser: requestAccessUser}}
            );
        }
    }

    requestAccessButton.click(function () {
        AJS.trigger('analyticsEvent', {name: 'confluence.request.access.plugin.request.access.to.page',
            data: {pageId: pageId, requestAccessUser: requestAccessUser}}
        );
        requestAccessButton.attr("aria-disabled", "true");

        var requestAccessResult,
            loading = $(Confluence.Request.Access.loading({}));

        requestAccessButton.replaceWith(loading);

        $.ajax({
            url: Confluence.getContextPath() + "/rest/request-access/latest/page/restriction/" + pageId,
            success: function (data) {
                requestAccessResult =
                    $(Confluence.Request.Access.result(
                        {
                            success: true,
                            recipient: data
                        }
                    )
                );
                restrictedPage.removeClass('page-restricted');
                restrictedPage.addClass('access-requested');
            },
            error: function (request, textStatus) {
                requestAccessResult = $(Confluence.Request.Access.result({success: false}));
            },
            complete: function () {
                loading.replaceWith(requestAccessResult);
                Confluence.Binder.userHover();
            }
        });
    });

})(AJS.$);