AJS.toInit(function ($) {
    var pageId = AJS.Meta.get("page-id"),
        grantAccessUser = AJS.Meta.get("remote-user"),
        requestAccessUsername = getParameterByName("username"),
        requestAccessFullName = getParameterByName("userFullName");

    var requestAccessFullNameArray = requestAccessFullName.split('+');
    requestAccessFullName = requestAccessFullNameArray.join(' ');


    // DOM element that includes the padlock will be the trigger, otherwise the inline dialog's arrow looks funny
    // as the the padlock is too small
    var $trigger = $("#system-content-items");
    // Figure out if the padlock is shown
    var isPageRestricted = $("#content-metadata-page-restrictions.restricted").length !== 0;

    // If padlock is not present, or URL does not have certain params - don't show grant access dialog
    if (!$trigger.length || !isPageRestricted || !getParameterByName("grantAccess")) {
        // if there is no padlock on the page, abort.
        return;
    }

    var loading = $(Confluence.Request.Access.loading());;

    var grantAccessDialog = AJS.InlineDialog($trigger, "grantAccessDialog",
        function (content, trigger, showPopup) {
            content.css({"padding": "20px"}).html(
                Confluence.Grant.Access.dialog(
                    {
                        requestAccessUsername: requestAccessUsername,
                        requestAccessUserFullName: requestAccessFullName
                    }
                )
            );
            content.on("click", '.aui-button.grant-access', function (e) {
                e.stopPropagation();

                var grantAccessButtons = content.find(".actions-result");
                grantAccessButtons.replaceWith(loading);

                // Logged in user grants access to the user requesting access
                AJS.trigger('analyticsEvent',
                    {
                        name: 'confluence.request.access.plugin.grant.access.to.page',
                        data: {pageId: pageId, grantAccessUser: grantAccessUser, requestAccessUser: requestAccessUsername}
                    }
                );

                var grantAccessResultMessage = "",
                    grantAccessSuccess = true;

                $.ajax({
                    url: Confluence.getContextPath() + "/rest/request-access/latest/page/restriction/" + pageId,
                    type: "POST",
                    contentType: "application/json; charset=utf-8",
                    data: requestAccessUsername,
                    success: function (data, textStatus, jqXHR) {
                        if (jqXHR.status == 202) {
                            grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.already.granted");
                        } else {
                            grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.notification.sent");
                        }
                    },
                    error: function (xhr) {
                        grantAccessSuccess = false;
                        if (xhr.status == 412) {
                            grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.no.mail.server");
                        } else if (xhr.status == 502) {
                            grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.error.sending.email");
                        } else {
                            grantAccessResultMessage = AJS.I18n.getText("confluence.request.access.error");
                        }
                    },
                    complete: function (xhr) {
                        loading.replaceWith($(Confluence.Grant.Access.result(
                            {success: grantAccessSuccess, message: grantAccessResultMessage})
                        ));
                        setTimeout(function () {
                            grantAccessDialog.hide();
                        }, 6000);
                    }
                });
            });

            content.on("click", '.aui-button.deny-access', function (e) {
                // Logged in user explicitly denies access to the user requesting access
                AJS.trigger('analyticsEvent',
                    {
                        name: 'confluence.request.access.plugin.deny.access.to.page',
                        data: {pageId: pageId, grantAccessUser: grantAccessUser, requestAccessUser: requestAccessUsername}
                    }
                );
                grantAccessDialog.hide();
            });
            showPopup();
            return false;
        },
        {
            offsetY: 2,
            offsetX: 0,
            width: 350,
            hideDelay: null,
            noBind: true,
            hideCallback: function () {
                setTimeout(grantAccessDialog.hide(), 5000);
            }
        }
    );

    grantAccessDialog.show();

    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }

})(AJS.$);
