/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.requestaccess.exception.RecipientNotFoundException;
import com.atlassian.confluence.plugins.requestaccess.service.UserNotificationService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.List;

public class UserNotificationServiceImpl
implements UserNotificationService {
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;

    public UserNotificationServiceImpl(PermissionManager permissionManager, SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public User findRequestAccessRecipient(AbstractPage page) throws RecipientNotFoundException {
        ConfluenceUser lastModifier = null;
        if (page instanceof Page && this.hasPermissionsToGrantAccess((User)(lastModifier = page.getLastModifier()), page)) {
            return lastModifier;
        }
        ConfluenceUser pageCreator = page.getCreator();
        if (pageCreator != null && !pageCreator.equals(lastModifier) && this.hasPermissionsToGrantAccess((User)pageCreator, page)) {
            return pageCreator;
        }
        List spaceAdmins = this.spaceManager.getSpaceAdmins(page.getSpace());
        for (User spaceAdmin : spaceAdmins) {
            if (!this.hasPermissionsToGrantAccess(spaceAdmin, page)) continue;
            return spaceAdmin;
        }
        throw new RecipientNotFoundException("No recipient for the request access notification was found.");
    }

    private boolean hasPermissionsToGrantAccess(User user, AbstractPage page) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page) && this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, (Object)page);
    }
}

