/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.content.render.xhtml.view.excerpt.Excerpter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.mail.notification.listeners.NotificationTemplate;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.requestaccess.exception.NotificationNotBuiltException;
import com.atlassian.confluence.plugins.requestaccess.service.MailService;
import com.atlassian.confluence.plugins.requestaccess.service.PageRestrictionNotificationService;
import com.atlassian.confluence.plugins.requestaccess.service.UserService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.util.collect.Predicate;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRestrictionNotificationMailService
implements PageRestrictionNotificationService {
    private static final Logger log = LoggerFactory.getLogger(PageRestrictionNotificationMailService.class);
    private static final String REQUEST_ACCESS_ADG_FEATURE = "request.access";
    private static final String ACCESS_GRANTED_ADG_FETAURE = "access.granted";
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final MailService mailService;
    private final DataSourceFactory dataSourceFactory;
    private final SettingsManager settingsManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final UserService userService;
    private final Excerpter excerpter;

    public PageRestrictionNotificationMailService(SpaceManager spaceManager, PermissionManager permissionManager, MailService mailService, DataSourceFactory dataSourceFactory, SettingsManager settingsManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, UserService userService, Excerpter excerpter) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.mailService = mailService;
        this.dataSourceFactory = dataSourceFactory;
        this.settingsManager = settingsManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.userService = userService;
        this.excerpter = excerpter;
    }

    @Override
    public void sendRequestAccessNotification(User requestAccessUser, User recipient, AbstractPage page) throws NotificationNotBuiltException {
        Preconditions.checkNotNull((Object)requestAccessUser, (Object)"requestAccessUser input param cannot be null");
        Preconditions.checkNotNull((Object)recipient, (Object)"recipient input param cannot be null");
        Preconditions.checkNotNull((Object)page, (Object)"page input param cannot be null");
        PreRenderedMailNotificationQueueItem mailTask = this.getRequestAccessMailTask(requestAccessUser, recipient, page);
        log.info("Sending email with subject:ScheduledThreadPoolExecutor {}", (Object)mailTask.getSubject());
        this.mailService.sendEmail((MailQueueItem)mailTask);
    }

    @Override
    public void sendGrantedAccessNotification(User grantingAccessUser, User grantedAccessUser, AbstractPage page) throws NotificationNotBuiltException {
        Preconditions.checkNotNull((Object)grantingAccessUser, (Object)"user input param cannot be null");
        Preconditions.checkNotNull((Object)grantedAccessUser, (Object)"grantedAccessUser input param cannot be null");
        Preconditions.checkNotNull((Object)page, (Object)"page input param cannot be null");
        PreRenderedMailNotificationQueueItem mailTask = this.getAccessGrantedMailTask(grantingAccessUser, grantedAccessUser, page);
        log.info("Sending email with subject: {}", (Object)mailTask.getSubject());
        this.mailService.sendEmail((MailQueueItem)mailTask);
    }

    private PreRenderedMailNotificationQueueItem getRequestAccessMailTask(User requestAccessUser, User recipient, AbstractPage page) throws NotificationNotBuiltException {
        NotificationData notificationData = new NotificationData(requestAccessUser, true, null);
        DataSource requestUserAvatarDataSource = this.dataSourceFactory.getAvatar(requestAccessUser);
        notificationData.addTemplateImage(requestUserAvatarDataSource);
        ContentEntityObject contentEntity = page.getContentEntityObject();
        DataSource contentIconDataSource = this.getContentIconDataSourceFor(contentEntity);
        if (contentIconDataSource != null) {
            notificationData.addTemplateImage(contentIconDataSource);
        }
        NotificationContext context = notificationData.cloneContext();
        context.setI18n(this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(recipient)));
        context.put("requestAccessUserAvatarCid", (Object)requestUserAvatarDataSource.getName());
        context.put("contentType", (Object)contentEntity.getType());
        this.buildRequestAccessEmailContext(context, page, requestAccessUser);
        String templateLocation = null;
        String templateName = null;
        if (NotificationTemplate.ADG.isEnabled(REQUEST_ACCESS_ADG_FEATURE)) {
            templateLocation = "com.atlassian.confluence.plugins.confluence-request-access-plugin:request-access-email-resources";
            templateName = "Confluence.Request.Access.Notification.requestAccess.soy";
        } else {
            templateLocation = "templates/email/";
            templateName = "request-access-notification.vm";
        }
        String accessRequestEMailSubject = this.getAccessRequestEMailSubject(recipient, requestAccessUser, page);
        log.debug("Rendering request-access email (TO: {}, SUBJECT: {})", (Object)recipient, (Object)accessRequestEMailSubject);
        PreRenderedMailNotificationQueueItem.Builder mailTaskBuilder = PreRenderedMailNotificationQueueItem.with((User)recipient, (String)templateName, (String)accessRequestEMailSubject).andSender(requestAccessUser).andTemplateLocation(templateLocation).andContext(context.getMap()).andRelatedBodyParts((Iterable)context.getTemplateImageDataSources());
        if (NotificationTemplate.ADG.isEnabled(REQUEST_ACCESS_ADG_FEATURE)) {
            mailTaskBuilder.andRelatedBodyParts(this.imagesUsedByChromeTemplate());
        }
        return mailTaskBuilder.render();
    }

    private void buildRequestAccessEmailContext(NotificationContext context, AbstractPage page, User requestAccessUser) throws NotificationNotBuiltException {
        boolean accessGrantedEmailIsADG = NotificationTemplate.ADG.isEnabled(REQUEST_ACCESS_ADG_FEATURE);
        log.debug("Request access email is " + (accessGrantedEmailIsADG ? "" : " not ") + "ADG'd");
        if (accessGrantedEmailIsADG) {
            context.put("requestAccessUser", (Object)requestAccessUser);
            context.put("ceo", (Object)page);
            String excerpt = null;
            try {
                excerpt = this.excerpter.createExcerpt((ContentEntityObject)page, "email");
                context.put("contentHtml", (Object)excerpt);
            }
            catch (Exception e) {
                log.error("Exception while rendering the request-access notification for page {} with exception {}", new Object[]{page, e});
                throw new NotificationNotBuiltException("There was a problem while getting the excerpt of the page", e);
            }
        } else {
            context.put("requestAccessUserFullName", (Object)requestAccessUser.getFullName());
            context.put("requestAccessUserUrlPath", (Object)this.userService.getUserProfileUrl(requestAccessUser));
            context.put("pageTitle", (Object)page.getDisplayTitle());
            context.put("pageUrlPath", (Object)this.getPageTargetUrl(page));
        }
        context.put("grantAccessActionUrlPath", (Object)this.getAddPageRestrictionActionUrlPath(page, requestAccessUser).toString());
    }

    private PreRenderedMailNotificationQueueItem getAccessGrantedMailTask(User grantingAccessUser, User grantedAccessUser, AbstractPage page) throws NotificationNotBuiltException {
        NotificationData notificationData = new NotificationData(grantingAccessUser, true, null);
        DataSource grantingAccessUserAvatarDatasource = this.dataSourceFactory.getAvatar(grantingAccessUser);
        notificationData.addTemplateImage(grantingAccessUserAvatarDatasource);
        ContentEntityObject contentEntity = page.getContentEntityObject();
        DataSource contentIconDataSource = this.getContentIconDataSourceFor(contentEntity);
        if (contentIconDataSource != null) {
            notificationData.addTemplateImage(contentIconDataSource);
        }
        NotificationContext context = notificationData.cloneContext();
        context.setI18n(this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(grantedAccessUser)));
        context.put("grantingAccessUserAvatarCid", (Object)grantingAccessUserAvatarDatasource.getName());
        context.put("contentType", (Object)contentEntity.getType());
        this.buildAccessGrantedEmailContext(context, page, grantingAccessUser);
        String templateLocation = null;
        String templateName = null;
        if (NotificationTemplate.ADG.isEnabled(ACCESS_GRANTED_ADG_FETAURE)) {
            templateLocation = "com.atlassian.confluence.plugins.confluence-request-access-plugin:request-access-email-resources";
            templateName = "Confluence.Access.Granted.Notification.accessGranted.soy";
        } else {
            templateLocation = "templates/email/";
            templateName = "access-granted-notification.vm";
        }
        String grantedAccessEmailSubject = this.getAccessGrantedEMailSubject(grantedAccessUser, page);
        log.debug("Rendering access-granted email (TO: {}, SUBJECT: {})", (Object)grantedAccessUser, (Object)grantedAccessEmailSubject);
        PreRenderedMailNotificationQueueItem.Builder mailTaskBuilder = PreRenderedMailNotificationQueueItem.with((User)grantedAccessUser, (String)templateName, (String)grantedAccessEmailSubject).andSender(grantingAccessUser).andTemplateLocation(templateLocation).andContext(context.getMap()).andRelatedBodyParts((Iterable)context.getTemplateImageDataSources());
        if (NotificationTemplate.ADG.isEnabled(ACCESS_GRANTED_ADG_FETAURE)) {
            mailTaskBuilder.andRelatedBodyParts(this.imagesUsedByChromeTemplate());
        }
        return mailTaskBuilder.render();
    }

    private void buildAccessGrantedEmailContext(NotificationContext context, AbstractPage page, User grantingAccessUser) throws NotificationNotBuiltException {
        boolean accessGrantedEmailIsADG = NotificationTemplate.ADG.isEnabled(ACCESS_GRANTED_ADG_FETAURE);
        log.debug("Access granted email is " + (accessGrantedEmailIsADG ? "" : " not ") + "ADG'd");
        if (accessGrantedEmailIsADG) {
            context.put("grantingAccessUser", (Object)grantingAccessUser);
            context.put("ceo", (Object)page);
            try {
                context.put("contentHtml", (Object)this.excerpter.createExcerpt((ContentEntityObject)page, "email"));
            }
            catch (Exception e) {
                log.error("Exception while rendering the grant-access notification for page {} with exception {}", new Object[]{page, e});
                throw new NotificationNotBuiltException("There was a problem while getting the excerpt of the page", e);
            }
        } else {
            context.put("grantingAccessUserFullName", (Object)grantingAccessUser.getFullName());
            context.put("grantingAccessUserProfileLinkUrl", (Object)this.userService.getUserProfileUrl(grantingAccessUser));
            context.put("pageTitle", (Object)page.getDisplayTitle());
            context.put("pageLinkUrl", (Object)this.getPageTargetUrl(page));
        }
    }

    private boolean hasPermissionsToGrantAccess(User user, Page page) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page) && this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, (Object)page);
    }

    private String getAccessRequestEMailSubject(User recipient, User requestAccessUser, AbstractPage page) {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(recipient)).getText("confluence.notification.request.access.subject", new Object[]{requestAccessUser.getFullName(), page.getTitle()});
    }

    private String getAccessGrantedEMailSubject(User recipient, AbstractPage page) {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(recipient)).getText("confluence.notification.access.granted.subject", new Object[]{page.getTitle()});
    }

    private String getAddPageRestrictionActionUrlPath(AbstractPage page, User requestAccessUser) {
        return new UrlBuilder(this.getBaseUrl() + "/pages/viewpage.action").add("pageId", page.getId()).add("username", requestAccessUser.getName()).add("userFullName", HtmlUtil.urlEncode((String)requestAccessUser.getFullName())).add("grantAccess", true).toString();
    }

    private DataSource getContentIconDataSourceFor(ContentEntityObject contentEntity) {
        if (contentEntity instanceof BlogPost) {
            return this.dataSourceFactory.getServletContainerResource("/images/icons/contenttypes/blog_post_16.png", "blogpost-icon");
        }
        if (contentEntity instanceof Page) {
            return this.dataSourceFactory.getServletContainerResource("/images/icons/contenttypes/page_16.png", "page-icon");
        }
        return null;
    }

    private String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    private String getPageTargetUrl(AbstractPage page) {
        return this.getBaseUrl() + page.getUrlPath();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        return (Iterable)((PluginDataSourceFactory)this.dataSourceFactory.forPlugin("com.atlassian.confluence.plugins.confluence-email-resources").get()).resourcesFromModules("chrome-template", (Predicate)PluginDataSourceFactory.FilterByType.IMAGE).get();
    }
}

