/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.requestaccess.service.PagePermissionChecker;
import com.atlassian.confluence.plugins.requestaccess.service.UserService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePermissionCheckerImpl
implements PagePermissionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagePermissionCheckerImpl.class);
    private final PermissionManager permissionManager;
    private final UserService userService;
    private final UserManager userManager;

    public PagePermissionCheckerImpl(PermissionManager permissionManager, UserService userService, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.userService = userService;
        this.userManager = userManager;
    }

    @Override
    public boolean canAuthenticatedUserGrantAccessToPage(AbstractPage page) {
        Preconditions.checkNotNull((Object)page);
        return this.permissionManager.hasPermission((User)this.userService.getAuthenticatedUser(), Permission.SET_PERMISSIONS, (Object)page);
    }

    @Override
    public boolean isUserPermittedToViewPage(String username, AbstractPage page) {
        Preconditions.checkNotNull((Object)page);
        try {
            User user = this.userManager.getUser(username);
            return !page.hasPermissions("View") || page.getContentPermissionSet("View").isPermitted(user);
        }
        catch (EntityException e) {
            LOGGER.info("Could not retrieve User entity by username [{}]", (Object)username);
            LOGGER.debug("Exception thrown while retrieve User entity.", (Throwable)e);
            return false;
        }
    }
}

