/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.requestaccess.service.GrantAccessRequestValidator;
import com.atlassian.confluence.plugins.requestaccess.service.PagePermissionChecker;
import com.atlassian.confluence.web.context.HttpContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantAccessRequestValidatorImpl
implements GrantAccessRequestValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrantAccessRequestValidatorImpl.class);
    private static final String PAGE_ID_REQUEST_PARAM = "pageId";
    private static final String USERNAME_REQUEST_PARAM = "username";
    private static final String GRANT_ACCESS_REQUEST_PARAM = "grantAccess";
    private final HttpContext httpContext;
    private final PageManager pageManager;
    private final PagePermissionChecker pagePermissionChecker;

    public GrantAccessRequestValidatorImpl(HttpContext httpContext, PageManager pageManager, PagePermissionChecker pagePermissionChecker) {
        this.httpContext = httpContext;
        this.pageManager = pageManager;
        this.pagePermissionChecker = pagePermissionChecker;
    }

    @Override
    public boolean isGrantAccessRequestValid() {
        if (this.httpContext.getRequest() != null && this.isAllGrantAccessParamsPresent()) {
            try {
                String username = this.httpContext.getRequest().getParameter(USERNAME_REQUEST_PARAM);
                long pageId = Long.valueOf(this.httpContext.getRequest().getParameter(PAGE_ID_REQUEST_PARAM));
                return this.isRequestAccessValid(pageId, username);
            }
            catch (NumberFormatException exc) {
                LOGGER.info("Invalid page id value: [{}]", (Object)this.httpContext.getRequest().getParameter(PAGE_ID_REQUEST_PARAM));
            }
        }
        return false;
    }

    private boolean isAllGrantAccessParamsPresent() {
        return StringUtils.isNotBlank((CharSequence)this.httpContext.getRequest().getParameter(PAGE_ID_REQUEST_PARAM)) && StringUtils.isNotBlank((CharSequence)this.httpContext.getRequest().getParameter(USERNAME_REQUEST_PARAM)) && StringUtils.isNotBlank((CharSequence)this.httpContext.getRequest().getParameter(GRANT_ACCESS_REQUEST_PARAM));
    }

    private boolean isRequestAccessValid(long pageId, String username) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        return page != null && this.pagePermissionChecker.canAuthenticatedUserGrantAccessToPage(page) && !this.pagePermissionChecker.isUserPermittedToViewPage(username, page);
    }
}

