/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.resource;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.requestaccess.entity.UserEntity;
import com.atlassian.confluence.plugins.requestaccess.exception.NotificationNotBuiltException;
import com.atlassian.confluence.plugins.requestaccess.exception.RecipientNotFoundException;
import com.atlassian.confluence.plugins.requestaccess.service.PageRestrictionNotificationService;
import com.atlassian.confluence.plugins.requestaccess.service.UserNotificationService;
import com.atlassian.confluence.plugins.requestaccess.service.UserService;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/page/restriction")
public class PageRestrictionResource {
    private static final Logger log = LoggerFactory.getLogger(PageRestrictionResource.class);
    private static final String CAN_VIEW_USER_PROFILE_PARAM = "canView";
    private static final String USERNAME_PARAM = "username";
    private static final String FULL_NAME_PARAM = "fullName";
    private static final String SHARED_TEMPLATES_MODULE_COMPLETE_KEY = "confluence.web.resources:shared-templates";
    private static final String USERNAME_LINK_SOY_TEMPLATE = "Confluence.Templates.User.usernameLink.soy";
    private final PageRestrictionNotificationService pageRestrictionService;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private final ContentPermissionManager contentPermissionManager;
    private final MailServerManager mailServerManager;
    private final I18nResolver i18nResolver;
    private final UserService userService;
    private final TemplateRenderer templateRenderer;
    private final TransactionTemplate transactionTemplate;
    private final UserNotificationService recipientNotificationService;

    public PageRestrictionResource(PageRestrictionNotificationService pageRestrictionService, PageManager pageManager, PermissionManager permissionManager, UserAccessor userAccessor, ContentPermissionManager contentPermissionManager, MailServerManager mailServerManager, I18nResolver i18nResolver, UserService userService, TemplateRenderer templateRenderer, TransactionTemplate transactionTemplate, UserNotificationService recipientNotificationService) {
        this.pageRestrictionService = pageRestrictionService;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.contentPermissionManager = contentPermissionManager;
        this.mailServerManager = mailServerManager;
        this.userService = userService;
        this.i18nResolver = i18nResolver;
        this.templateRenderer = templateRenderer;
        this.transactionTemplate = transactionTemplate;
        this.recipientNotificationService = recipientNotificationService;
    }

    @GET
    @Path(value="/{pageId}")
    @Produces(value={"application/json"})
    public Response request(final @PathParam(value="pageId") long pageId) {
        final ConfluenceUser authenticatedUser = this.userService.getAuthenticatedUser();
        log.info("User {} has requested access to pageId {}", new Object[]{authenticatedUser, pageId});
        return (Response)this.transactionTemplate.execute(new TransactionCallback(){

            public Response doInTransaction() {
                AbstractPage page = PageRestrictionResource.this.pageManager.getAbstractPage(pageId);
                if (!PageRestrictionResource.this.permissionManager.hasPermission((User)authenticatedUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
                    return Response.status((int)403).build();
                }
                if (page == null || page.isDeleted()) {
                    return Response.status((int)404).build();
                }
                User notificationRecipient = null;
                try {
                    notificationRecipient = PageRestrictionResource.this.recipientNotificationService.findRequestAccessRecipient(page);
                    PageRestrictionResource.this.pageRestrictionService.sendRequestAccessNotification((User)authenticatedUser, notificationRecipient, page);
                }
                catch (RecipientNotFoundException e) {
                    log.error("No recipient for the request access notification was found", new Object[]{authenticatedUser, pageId});
                    return Response.status((int)412).build();
                }
                catch (NotificationNotBuiltException e) {
                    log.error("Exception while rendering the notification", new Object[]{authenticatedUser, pageId, e});
                    return Response.serverError().build();
                }
                return Response.ok((Object)new UserEntity(notificationRecipient)).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
        });
    }

    @POST
    @Path(value="/{pageId}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    public Response add(@PathParam(value="pageId") long pageId, String username) {
        ConfluenceUser authenticatedUser = this.userService.getAuthenticatedUser();
        log.info("User {} is requesting access for user {} to page {}", new Object[]{authenticatedUser, username, pageId});
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((int)400).build();
        }
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        if (page == null) {
            return Response.status((int)404).build();
        }
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null) {
            return Response.status((int)404).build();
        }
        if (!this.permissionManager.hasPermission((User)authenticatedUser, Permission.SET_PERMISSIONS, (Object)page)) {
            return Response.status((int)403).build();
        }
        try {
            if (page.getContentPermissionSet("View").isPermitted((User)user)) {
                return Response.status((int)202).build();
            }
            this.addPageRestriction(page, user);
        }
        catch (Exception e) {
            log.error("Error when adding permissions to user {} for page {}", new Object[]{authenticatedUser, pageId, e});
            return Response.status((int)500).build();
        }
        try {
            if (!this.mailServerManager.isDefaultSMTPMailServerDefined()) {
                return Response.status((int)412).build();
            }
            this.pageRestrictionService.sendGrantedAccessNotification((User)authenticatedUser, (User)user, page);
        }
        catch (NotificationNotBuiltException e) {
            log.warn("Error when notifying user {} about access being granted to {}", new Object[]{authenticatedUser, pageId, e});
            return Response.status((int)502).build();
        }
        return Response.status((int)200).build();
    }

    private void addPageRestriction(AbstractPage page, ConfluenceUser user) {
        ContentPermission viewContentPermission = ContentPermission.createUserPermission((String)"View", (ConfluenceUser)user);
        this.contentPermissionManager.addContentPermission(viewContentPermission, (ContentEntityObject)page);
    }
}

