/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.quicknav.admin;

import com.atlassian.confluence.search.actions.json.ContentNameMatch;
import com.atlassian.confluence.search.contentnames.ContentNameSearchContext;
import com.atlassian.confluence.search.contentnames.ContentNameSearchSection;
import com.atlassian.confluence.search.contentnames.ContentNameSearchSectionsProvider;
import com.atlassian.confluence.search.contentnames.QueryToken;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AdminItemSearchSectionProvider
implements ContentNameSearchSectionsProvider {
    private static final int MAX_RESULTS = 3;
    private static final String LOCATION = "system.admin";
    private static final int WEIGHT = 5;
    private WebInterfaceManager webInterfaceManager;
    private PermissionManager permissionManager;

    public Collection<ContentNameSearchSection> getSections(List<QueryToken> queryTokens, ContentNameSearchContext context) {
        boolean confAdmin = this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
        boolean typeSpecificSearch = context.getTypes().iterator().hasNext();
        if (!confAdmin || typeSpecificSearch) {
            return null;
        }
        List<ContentNameMatch> contentNameMatches = this.searchAdminItems(queryTokens);
        return Lists.newArrayList((Object[])new ContentNameSearchSection[]{new ContentNameSearchSection(Integer.valueOf(5), contentNameMatches)});
    }

    private ImmutableMap<String, Object> contextForWebInterfaceManager() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return ImmutableMap.of((Object)"user", (Object)user);
    }

    public List<ContentNameMatch> searchAdminItems(List<QueryToken> queryTokens) {
        Iterable matchedAdminItems = this.searchItems(this.getAdminItems(), queryTokens);
        matchedAdminItems = Iterables.limit(matchedAdminItems, (int)3);
        return this.transformWebItemsToContentNameMatches(matchedAdminItems);
    }

    private List<WebItemModuleDescriptor> getAdminItems() {
        ImmutableMap<String, Object> context = this.contextForWebInterfaceManager();
        ArrayList<WebItemModuleDescriptor> items = new ArrayList<WebItemModuleDescriptor>();
        List displayableSections = this.webInterfaceManager.getDisplayableSections(LOCATION, context);
        for (WebSectionModuleDescriptor section : displayableSections) {
            String sectionKey = "system.admin/" + section.getKey();
            List displayableItems = this.webInterfaceManager.getDisplayableItems(sectionKey, context);
            items.addAll(displayableItems);
        }
        return items;
    }

    private List<ContentNameMatch> transformWebItemsToContentNameMatches(Iterable<WebItemModuleDescriptor> webItemModuleDescriptors) {
        HttpServletRequest servletRequest = ServletContextThreadLocal.getRequest();
        ImmutableMap<String, Object> context = this.contextForWebInterfaceManager();
        return Lists.newArrayList((Iterable)Iterables.transform(webItemModuleDescriptors, webItemModuleDescriptor -> {
            ContentNameMatch match = new ContentNameMatch();
            match.setClassName("admin-item");
            match.setHref(webItemModuleDescriptor.getLink().getDisplayableUrl(servletRequest, context));
            match.setName(webItemModuleDescriptor.getWebLabel().getDisplayableLabel(servletRequest, context));
            return match;
        }));
    }

    private Iterable<WebItemModuleDescriptor> searchItems(List<WebItemModuleDescriptor> items, List<QueryToken> query) {
        HttpServletRequest servletRequest = ServletContextThreadLocal.getRequest();
        ImmutableMap<String, Object> context = this.contextForWebInterfaceManager();
        return Iterables.filter(items, webItemModuleDescriptor -> {
            String label = webItemModuleDescriptor.getWebLabel().getDisplayableLabel(servletRequest, context);
            return Iterables.all((Iterable)query, token -> StringUtils.containsIgnoreCase((CharSequence)label, (CharSequence)token.getText()));
        });
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

