require([
    'ajs',
    'confluence-quick-reload/main/quick-reload-manager',
    'confluence-quick-reload/handlers/quick-reload-comments',
    'confluence-quick-reload/handlers/quick-reload-inline-comments',
    'confluence-quick-reload/handlers/quick-reload-page',
    'confluence/legacy'
],
/**
 * On DomContentLoaded, checks that conditions are right for enabling quick reload and if they are, starts quick reload
 *
 * @tainted Confluence.CommentDisplayManager
 * @tainted AJS.DarkFeatures
 */
function(
    AJS,
    QuickReloadManager,
    commentHandler,
    inlineCommentHandler,
    pageEditHandler,
    Confluence
) {
    "use strict";

    AJS.toInit(function ($) {

        if (_isCompatible()) {
            QuickReloadManager.addHandler(commentHandler);
            QuickReloadManager.addHandler(inlineCommentHandler);
            QuickReloadManager.addHandler(pageEditHandler);

            QuickReloadManager.enable();

            AJS.bind("page.commentAddedOrUpdated", function (e, data) {
                commentHandler.ignoreOnce(data.commentId);
            });
        }
    });

    function _isCompatible() {
        if (AJS.DarkFeatures.isEnabled('quickreload.disabled')) {
            return false;
        }

        // We need CommentDisplayManager to continue
        if (!Confluence.CommentDisplayManager) {
            return false;
        }

        // Don't activate quick reload if we don't have a page-id (e.g. page embedded in page gadgets)
        if (AJS.Meta.get("page-id") === undefined) {
            return false;
        }

        return true;
    }
});

