/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.quickreload;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ParametersAreNonnullByDefault
public class QuickReloadCaches
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(QuickReloadCaches.class);
    private static final String CACHE_NAME = QuickReloadCaches.class.getName() + ".lastUpdate";
    private final Supplier<StableReadExternalCache<Long>> lastUpdateCacheRef = Lazy.supplier(() -> QuickReloadCaches.createCache(cacheFactory));
    private final EventPublisher eventPublisher;

    public QuickReloadCaches(EventPublisher eventPublisher, VCacheFactory cacheFactory) {
        this.eventPublisher = eventPublisher;
    }

    private static StableReadExternalCache<Long> createCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(Long.class), new ExternalCacheSettingsBuilder().build());
    }

    public boolean hasUpdates(long contentId, long since) {
        return ((Optional)VCacheUtils.fold((CompletionStage)this.lastUpdateCache().get(QuickReloadCaches.cacheKey(contentId)), Function.identity(), ex -> {
            log.warn("Failed to retrieve cache entry: {}", (Object)ex.getMessage());
            return Optional.empty();
        })).map(lastUpdate -> lastUpdate > since).orElse(true);
    }

    private StableReadExternalCache<Long> lastUpdateCache() {
        return (StableReadExternalCache)this.lastUpdateCacheRef.get();
    }

    private static String cacheKey(long contentId) {
        return String.valueOf(contentId);
    }

    public void updateLastUpdate(long contentId, long timestamp) {
        Long lastUpdate = (Long)VCacheUtils.fold((CompletionStage)this.lastUpdateCache().get(QuickReloadCaches.cacheKey(contentId), () -> timestamp), Function.identity(), ex -> {
            log.warn("Failed to fetch cache entry: {}", (Object)ex.getMessage());
            return timestamp;
        });
        if (lastUpdate < timestamp) {
            this.lastUpdateCache().put(QuickReloadCaches.cacheKey(contentId), (Object)timestamp, PutPolicy.PUT_ALWAYS);
        }
    }

    @EventListener
    public void onPageUpdate(PageUpdateEvent evt) {
        this.updateLastUpdate(evt.getPage().getId(), evt.getTimestamp());
    }

    @EventListener
    public void onComment(CommentEvent evt) {
        ContentEntityObject owner = evt.getComment().getContainer();
        this.updateLastUpdate(owner.getId(), evt.getTimestamp());
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.lastUpdateCache();
        this.eventPublisher.register((Object)this);
    }
}

