define('confluence-paste/autoconvert/transformers/youtube', [
    'tinymce',
    'jquery'
], function(
    tinymce,
    $
) {
    "use strict";

    function YouTube() {
        tinymce.plugins.Autoconvert.autoConvert.addHandler(function(uri, node, done){
            if (uri.host.match('.*youtu\.be.*')) {
                var vidId = uri.path.substr(1);
                var newurl = "http://youtube.com/watch?v=" + vidId;
                done($(node).attr("href", newurl).html(newurl));
            } else {
                done();
            }
        });
    }

    return YouTube;
});

require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/youtube', function(YouTube) {
    require('ajs').bind("init.rte", YouTube);
});