define('confluence-paste/autoconvert/transformers/widgetpaste', [
    'tinymce'
], function(
    tinymce
) {
    "use strict";

    function WidgetPaste() {
        var pasteRegexes = [/youtube.com\/watch\?/, /vimeo.com\/[0-9]+/, /maps.google(.[a-z]+)+\/maps/, /[^\.]\.wufoo\.com\/(?:forms|reports)/];

        function pasteHandler(uri, node, done){
            var urlSrc = decodeURI(uri.source);

            for (var i = 0; i < pasteRegexes.length; i++){
                if (urlSrc.match(pasteRegexes[i])){
                    var macro = {name:'widget', params: {url: urlSrc}};
                    tinymce.plugins.Autoconvert.convertMacroToDom(macro, done, done);
                    return;
                }
            }
            done();
        }

        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return WidgetPaste;
});

require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/widgetpaste', function(WidgetPaste) {
    require('ajs').bind("init.rte", WidgetPaste);
});