define('confluence-paste/autoconvert/transformers/skitchpaste', [
    'ajs',
    'jquery',
    'confluence/api/constants'
], function(
    AJS,
    $,
    CONSTANTS
) {
    "use strict";

    var SkitchPaste = {
        pasteHandler : function(uri,node, done){
            if (uri.host === 'www.skitch.com' || uri.host === 'skitch.com'){
                $.get(CONSTANTS.CONTEXT_PATH + '/rest/autoconvert/1.0/skitchembed?url=' + uri.source, function(data){
                    if (data && data.url){
                        done($('<img class="confluence-embedded-image confluence-external-resource" src="' + data.url + '" data-image-src="' + data.url + '"/>')[0]);
                    }
                    else{
                        done();
                    }
                });
            }
            else{
                done();
            }
        }
    };

    return SkitchPaste;
});

require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/skitchpaste', function(SkitchPaste) {
    var AJS = require('ajs');
    var tinymce = require('tinymce');

    AJS.bind("init.rte", function() {
        AJS.Editor.SkitchPaste = SkitchPaste;
        tinymce.plugins.Autoconvert.autoConvert.addHandler(SkitchPaste.pasteHandler);
    });
});
