define('confluence-paste/autoconvert/transformers/linkedin', [
    'jquery',
    'ajs',
], function(
    $,
    AJS
) {
    "use strict";

    function linkedInPasteHandler(uri, node, done) {
        // After doing some rough testing, most pages on LinkedIn tends to respond within a second,
        // however, some requests took up to 3526ms. Setting it with a little bit of a redundancy.
        var TIMEOUT = 5000;
        // Food for thought: What if I paste in a shortened link? e.g. a bit.ly link or something
        // Convert? No?
        if (uri.host.search('\.linkedin\.') === -1) {
            done();
            return;
        }

        var requestURL = "https://card-meta.atlassian.io/meta?url=" + uri.source;

        $.ajax(requestURL, {
            timeout: TIMEOUT,
            success: function(data) {
                // when pasting in a private link, LinkedIn will redirect
                // to a sign in page. It doesn't make sense to convert the link
                // title in that case, so just don't convert
                if (data.title.search("Sign In") !== -1) {
                    return;
                }

                // Removes "| LinkedIn" from profiles and articles
                var indexOfPipe = data.title.indexOf("|");
                var linkText = (indexOfPipe === -1)? data.title : data.title.substring(0, indexOfPipe);

                node.text(linkText);
                node.attr('href', uri.source);
            },
            error: function(xhr, errorStatus) {
                AJS.log("Link conversion failed, Error: " + errorStatus);
            },
            complete: function(xhr, textStatus) {
                done();
            }
        });
    }

    return linkedInPasteHandler;
});

require('confluence/module-exporter')
    .safeRequire('confluence-paste/autoconvert/transformers/linkedin', function(linkedInPasteHandler) {
        var AJS = require('ajs');
        if (AJS.DarkFeatures.isEnabled("autoconvert-link-to-page-title")) {
            AJS.bind("init.rte", function() {
                var tinymce = require("tinymce");
                tinymce.plugins.Autoconvert.autoConvert.addHandler(linkedInPasteHandler);
            });
        }
});
