define('confluence-paste/autoconvert/transformers/google-redirect-convert', [
    'jquery',
    'tinymce'
], function(
    $,
    tinymce
) {
    "use strict";

    function GoogleRedirectConvert() {
        var pasteHandler = function(uri, node, done){
            if (uri.host.match(/google.*/) && uri.path === "/url" && uri.queryKey && uri.queryKey.url) {
                var newUri = decodeURIComponent(uri.queryKey.url);
                node = $(node);
                // currently need to do both of these due to the editor storage format
                node.attr('href', newUri);
                node.attr('data-mce-href', newUri);
                node.text(newUri);
                done(node);
            } else {
                done();
            }

        };

        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return GoogleRedirectConvert;
});


require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/google-redirect-convert', function(GoogleRedirectConvert) {
    require('ajs').bind("init.rte", GoogleRedirectConvert);
});
