define('confluence-paste/autoconvert/transformers/flickrpaste', [
    'tinymce'
], function(
    tinymce
) {
    "use strict";

    function FlickrPaste() {
        var tagPathRegex = /^\/photos\/tags\/[^/]+/;
        var setPathRegex = /^\/photos\/[^/]+\/sets\/[0-9]+/;
        var photoPathRegex = /^\/photos\/[^/]+\/[0-9]+/;
        var pasteHandler = function (uri, node, done) {
            var decodedPath;

            if (uri.host.match(/flickr.com/)) {
                decodedPath = decodeURIComponent(uri.path);
                if (decodedPath.match(tagPathRegex) ||
                        decodedPath.match(setPathRegex) ||
                        decodedPath.match(photoPathRegex)) {
                    var macro = {name: 'widget', params: {url: decodeURI(uri.source)}};
                    tinymce.plugins.Autoconvert.convertMacroToDom(macro, done, done);
                }
                else {
                    done();
                }
            }
            else {
                done();
            }
        };
        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return FlickrPaste;
});

require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/flickrpaste', function(FlickrPaste) {
    require('ajs').bind("init.rte", FlickrPaste);
});
