define('confluence-paste/autoconvert/transformers/confluencepaste', [
    'ajs',
    'tinymce',
    'jquery',
    'document'
], function(
    AJS,
    tinymce,
    $,
    document
) {
    "use strict";

    function ConfluencePaste() {
        var pasteHandler =function(uri, node, done){
            if (!isConfluence(uri)) {
                done();
                return;
            }

            var stripContextPath = function(uri){
                return AJS.contextPath() ? uri.path.substring(AJS.contextPath().length + 1) : uri.path.substring(1);
            };

            var path = stripContextPath(uri);
            var parts = decodeURIComponent(path).split('/');
            var linkString;

            // All URIs provided by the parseUri function should have *at least* an empty queryKey object but we'll guard
            // anyway.
            uri.queryKey = uri.queryKey || {};

            var addAnchorSuffix = function (linkString, uri) {
                if (!uri.anchor || uri.anchor.indexOf('comment-') === 0) {
                    // Ignore anchors for focused comments; they're handled by the $ wiki markup.
                    return linkString;
                }
                return linkString + '#' + uri.anchor.substring(uri.anchor.indexOf('-') + 1);
            };

            if (uri.queryKey.focusedCommentId) {
                //http://localhost:8080/confluence/display/ds/Home&focusedCommentId=1212425#comment-1212425
                //http://localhost:8080/confluence/pages/viewpage.action?pageId=32784&focusedCommentId=1212425#comment-1212425
                linkString = '$' + uri.queryKey.focusedCommentId;
                // HACK - although the anchor may be added it is currently ignored by the wiki converter.
                // In fact the "$12345" comment linkString above will be converted to a hard href, see CONF-24415.
                linkString = addAnchorSuffix(linkString, uri);
            } else if (uri.queryKey.pageId) {
                //http://localhost:8080/confluence/pages/viewpage.action?pageId=32784
                linkString = '$' + uri.queryKey.pageId;
                linkString = addAnchorSuffix(linkString, uri);
            }
            else if (parts[0] === 'display') {
                if (parts.length === 2 && parts[1].indexOf('~') === 0) {
                    //http://localhost:8080/confluence/display/~admin
                    linkString = parts[1];
                } else if (parts.length === 3) {
                    //http://localhost:8080/confluence/display/ds/Home
                    linkString =  parts[1] + ':' + parts[2].replace(/\+/g, ' ');
                    linkString = addAnchorSuffix(linkString, uri);
                } else if (parts.length === 4 && parts[1] === "status") {
                    //http://localhost:8080/confluence/display/status/admin/1212424
                    linkString = '$' + parts[3];
                } else if (parts.length === 6) {
                    //http://localhost:8080/confluence/display/ds/2011/10/27/jwafej+again+dog
                    linkString = parts[1] + ':' + '/' + parts[2] + '/' + parts[3] + '/' + parts[4] + '/' + parts[5].replace(/\+/g, ' ');
                    linkString = addAnchorSuffix(linkString, uri);
                }
            } else if (parts[0] == 'users') {
                if (parts.length === 2 && parts[1] == 'viewuserprofile.action') {
                    // http://localhost:8090/confluence/users/viewuserprofile.action?username=admin
                    linkString = '~' + uri.queryKey.username;
                } else if (parts.length === 2 && parts[1] == 'viewmyprofile.action') {
                    linkString = '~' + AJS.Meta.get('remote-user');
                }
            }

            if (!linkString) {
                // Nothing matches this Confluence URI, leave it alone.
                done();
                return;
            }

            linkString = "[" + linkString + "]";
            tinymce.plugins.Autoconvert.getHtmlFromWikiMarkup(
                    linkString,
                    function(data){
                        done($(data).children()[0]);
                    },
                    function(){
                        done();
                    });
        };

        var isConfluence = function(uri){
            var isConfluence = true;
            isConfluence = isConfluence && uri.authority === document.location.host;
            isConfluence = isConfluence && (!AJS.contextPath() || uri.path.indexOf(AJS.contextPath()) === 0);
            return isConfluence;
        };


        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return ConfluencePaste;
});


require('confluence/module-exporter').safeRequire('confluence-paste/autoconvert/transformers/confluencepaste', function(ConfluencePaste) {
    var AJS = require('ajs');
    AJS.bind("init.rte", ConfluencePaste);
});