define('confluence-paste/autoconvert/transformers/cloudapppaste', [
    'ajs',
    'jquery',
    'confluence/api/constants'
], function(
    AJS,
    $,
    CONSTANTS
) {
    "use strict";

    function pasteHandler(uri, node, done){
        if (uri.host == 'cl.ly') {
            $.get(CONSTANTS.CONTEXT_PATH + '/rest/autoconvert/1.0/cloudappembed?resource=' + uri.path.substr(1), function(data){
                if (data){
                    switch(data.item_type) {
                        case 'image' :
                            var image = AJS.escapeHtml(data.content_url);
                            done($('<img class="confluence-embedded-image confluence-external-resource" src="' + image + '" data-image-src="' + image + '"/>')[0]);
                            break;
                        case 'bookmark' :
                            node.text(data.name);
                            node.attr('href', AJS.escapeHtml(data.redirect_url));
                            done(node);
                            break;
                    }
                    return;
                }
                else{
                    done();
                }
            });
        } else {
            done();
            return;
        }
    }

    return pasteHandler;
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-paste/autoconvert/transformers/cloudapppaste', 'AJS.Editor.CloudAppPaste', function(CloudAppPaste) {
    var AJS = require('ajs');
    var tinymce = require('tinymce');

    AJS.bind("init.rte", function() {
        tinymce.plugins.Autoconvert.autoConvert.addHandler(CloudAppPaste);
    });
});