define('confluence/ob/modules/tutorial/view-page/create-sequence', [
    'jquery',
    'underscore',
    'confluence/ob/modules/tutorial/view-page/base-sequence'
], function ($, _, BaseSequence) {
    'use strict';

    var id = 'onboarding-tour-create-button';

    function createSequence() {}

    createSequence.prototype = new BaseSequence({
        id: id,
        trigger: '#create-page-button',
        data: {
            id: id,
            alignment: 'bottom center',
            text: AJS.I18n.getText('onboarding.sequence.viewPage.createButton.text'),
            buttonClass: 'aui-button-primary',
            buttonText: AJS.I18n.getText('onboarding.editor.popup.button.okay'),
            extraClass: 'view-page'
        }
    });

    createSequence.prototype.afterShowPopup = function($popup) {
        BaseSequence.prototype.afterShowPopup.call(this, $popup);

        // Handler the case that user active quick-edit page.
        AJS.bind('rte-quick-edit-ready', function () {
            $popup[0].remove();
        });
    };

    return createSequence;
});