define('confluence/ob/modules/intro/space-creation', [
    'jquery',
    'confluence/ob/common/common-core',
    'confluence/ob/common/space-utils'
], function ($, CommonCore, SpaceUtils) {
    var SpaceCreation = {};

    SpaceCreation.createSpace = function(spaceName) {
        var deferred = $.Deferred();

        var spaceKey = SpaceUtils.generateSpaceKey(spaceName);

        SpaceUtils.generateUniqueSpaceKey(spaceKey)
                .done(function(key) {
                    SpaceUtils.createSpace(spaceName, key)
                            .done(function(spacesDetails) {
                                if (!$.isArray(spacesDetails)) {
                                    spacesDetails = [ spacesDetails ];
                                }
                                deferred.resolve(spacesDetails);
                            })
                            .fail(function(err) {
                                deferred.reject(err);
                            });
                })
                .fail(function(err) {
                    deferred.reject(err);
                });

        return deferred.promise();
    };

    return SpaceCreation;
});
