define('confluence/ob/modules/intro/intro-sequence-utils', [
    'jquery',
    'underscore',
    'confluence/ob/modules/intro-container/intro-container',
    'confluence/ob/modules/intro-progress/intro-progress',
    'confluence/ob/common/user',
    'confluence/ob/common/test-evaluator'
], function($, _, IntroContainer, IntroProgress, User, TestEvaluator) {
    'use strict';

    // This needs to be in the place where TestEvaluator.isTestingEvaluator is first called.
    TestEvaluator.resetTestingEvaluator();

    var navContainerSelector = "#grow-ic-nav-container";
    var contentContainerSelector = "#grow-ic-content";

    var steps = [
        {
            name: 'video',
            title : AJS.I18n.getText('onboarding.sequence.welcome')
        },
        {
            name: 'upload-avatar',
            title : AJS.I18n.getText('onboarding.sequence.upload.avatar')
        },
        {
            name: 'create-space',
            title : AJS.I18n.getText('onboarding.sequence.create.space')
        },
        {
            name: 'find-spaces',
            title : AJS.I18n.getText('onboarding.sequence.find.spaces')
        }
    ];

    function getSteps() {
        if (TestEvaluator.isTestingEvaluator() && !User.hasCreateSpacePermission()) {
            console.log('WARN: ignore testing evaluator flow because current user does not have create space permission');
        }

        var showCreateSpace = User.hasCreateSpacePermission() && (TestEvaluator.isTestingEvaluator() ||
                User.isAdmin() && User.hasCreateSpacePermission() && !User.isFirstSpaceCreated());

        var availableSpaces = AJS.Meta.get('available-spaces-count');
        var hasSpacesForFind = false;
        if (availableSpaces && (parseInt(availableSpaces) > 0)) {
            hasSpacesForFind = true;
        }

        return _.filter(steps, function(step) {
            switch (step.name) {
                case 'create-space':
                    return showCreateSpace;
                case 'find-spaces':
                    return !showCreateSpace && hasSpacesForFind;
                default:
                    return true;
            }
        });
    }

    var utils = {};

    utils.createProgressTracker = function(currentStep) {
        IntroContainer.createIntroContainer({
            currentState: currentStep
        });

        var $progressTracker = IntroProgress.createProgressTracker(getSteps(), currentStep);
        $(navContainerSelector).empty().append($progressTracker);

        return $(contentContainerSelector).empty();
    };

    utils.hasStep = function(stepName) {
        return !!_.findWhere(getSteps(), {name: stepName});
    };

    return utils;
});