define('confluence/ob/flow/main/tutorial-workflow', [
    'jquery',
    'confluence/ob/modules/tutorial/editor/editor-sequence',
    'confluence/ob/modules/tutorial/view-page/sidebar-sequence',
    'confluence/ob/modules/tutorial/view-page/create-sequence',
    'confluence/ob/modules/tutorial/comment/comment-highlight-sequence',
    'confluence/ob/modules/tutorial/comment/comment-demo-sequence',
    'confluence/ob/modules/tutorial/remove-demo-space/remove-demo-space-sequence'
], function ($, EditorSequence, SidebarSequence, CreateSequence, CommentSequence, CommentDemoSequence, RemoveDemoSpaceSequence) {
    var TestEvaluator = require('confluence/ob/common/test-evaluator');

    return function IntroWorkflow(complete) {
        function completeOrRemoveDemoSpace() {
            AJS.trigger('analyticsEvent', {
                name: 'onboarding.completed',
                data: {}
            });

            var spaceKey = sessionStorage.getItem('created-space-key');
            if (TestEvaluator.isTestingEvaluator() && spaceKey) {
                return 'removeDemoSpace';
            } else {
                complete();
            }
        }

        var states = {
            editorTour: {
                instance: new EditorSequence(),
                resolve: 'sidebar',
                reject: completeOrRemoveDemoSpace
            },
            sidebar: {
                instance: new SidebarSequence(),
                resolve: 'createButton'
            },
            createButton: {
                instance: new CreateSequence(),
                resolve: 'commentHighlight'
            },
            commentHighlight: {
                instance: new CommentSequence(),
                resolve: 'commentDemo'
            },
            commentDemo: {
                instance: new CommentDemoSequence(),
                resolve: completeOrRemoveDemoSpace
            },
            removeDemoSpace: {
                instance: new RemoveDemoSpaceSequence(),
                resolve: complete
            }
        };

        return {
            key: "tutorialFlow",
            start: "editorTour",
            sequences: states
        };
    };
});
