define('confluence/ob/flow/controller/session-progress-tracker', [
    'jquery'
], function ($) {
    'use strict';

    function buildStorageKey(flowKey) {
        return "onboarding-state:" + flowKey;
    }

    function set(key, value) {
        var d = $.Deferred();
        d.resolve(sessionStorage.setItem(key, value));
        return d.promise();
    }

    function get(key) {
        var d = $.Deferred();
        d.resolve(sessionStorage.getItem(key));
        return d.promise();
    }

    return {
        completeFlow: function(flowKey) {
            $.cookie('load-tutorial-flow', null, {path: '/'});
            return set(buildStorageKey(flowKey), "__complete__");
        },

        setCurrentFlowSequence: function(flowKey, sequenceKey) {
            $.cookie('load-tutorial-flow', 'true', {path: '/'});
            return set(buildStorageKey(flowKey), sequenceKey);
        },

        getCurrentFlowSequence: function(flowKey) {
            return get(buildStorageKey(flowKey));
        }
    }
});