/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.notifications;

import com.atlassian.confluence.efi.emails.notifications.OnboardingPayload;
import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RecipientsProviderTemplate;
import com.atlassian.confluence.notifications.content.NotificationUserService;
import com.atlassian.confluence.notifications.content.WatchTypeUtil;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Maybe;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class OnboardingRecipientsProvider
extends RecipientsProviderTemplate<OnboardingPayload> {
    private static final ConfluenceUserRole ONBOARDING_ROLE = new ConfluenceUserRole("ONBOARDING");
    private UserAccessor userAccessor;
    private NotificationUserService notificationUserService;

    public OnboardingRecipientsProvider(UserAccessor userAccessor, NotificationUserService notificationUserService) {
        this.userAccessor = userAccessor;
        this.notificationUserService = notificationUserService;
    }

    protected Iterable<RoleRecipient> computeUserBasedRecipients(Notification<OnboardingPayload> notification) {
        Maybe originator = notification.getOriginator();
        UserKey userKey = (UserKey)originator.get();
        ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
        ArrayList roleRecipients = Lists.newArrayList();
        roleRecipients.add(new UserKeyRoleRecipient((UserRole)ONBOARDING_ROLE, user.getKey(), originator.isDefined() && ((UserKey)originator.get()).equals((Object)user.getKey())));
        return roleRecipients;
    }

    public Iterable<UserRole> getUserRoles() {
        return WatchTypeUtil.watchTypesToUserRoles();
    }
}

