/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications;

import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.sal.api.user.UserKey;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PayloadBasedNotification<PAYLOAD extends NotificationPayload>
implements Notification<PAYLOAD> {
    private final PAYLOAD payload;
    private final ModuleCompleteKey key;
    private final UUID id;

    public PayloadBasedNotification(PAYLOAD payload, ModuleCompleteKey moduleCompleteKey) {
        this.key = moduleCompleteKey;
        this.payload = payload;
        this.id = UUID.randomUUID();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public ModuleCompleteKey getKey() {
        return this.key;
    }

    @Override
    public PAYLOAD getPayload() {
        return this.payload;
    }

    @Override
    public Maybe<UserKey> getOriginator() {
        Maybe<String> originatingUserKey = this.payload.getOriginatingUserKey();
        if (originatingUserKey.isDefined()) {
            return Option.some((Object)new UserKey((String)originatingUserKey.get()));
        }
        return Option.none();
    }

    public String toString() {
        Maybe<String> originatingUserKey = this.payload.getOriginatingUserKey();
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append("key", (Object)this.key).append("payload", this.payload).append("id", (Object)this.id).append("originator", originatingUserKey.isDefined() ? originatingUserKey.get() : "null");
        return toStringBuilder.toString();
    }
}

