define('confluence/monitoring-console', [
    'jquery',
    'confluence/dark-features',
    'ajs'
], function(
    $,
    DarkFeatures,
    AJS
) {
    "use strict";

    function MonitoringConsole() {
        function truncateDecimals(num, digits) {
            var numS = num.toString();
            var decPos = numS.indexOf('.');
            var substrLength = decPos === -1 ? numS.length : 1 + decPos + digits;
            var trimmedResult = numS.substr(0, substrLength);
            var finalResult = isNaN(trimmedResult) ? 0 : trimmedResult;

            return parseFloat(finalResult);
        }

        // Taken from the DataTables website, the common way to reload AJAX data
        $.fn.dataTableExt.oApi.fnReloadAjax = function ( oSettings, sNewSource, fnCallback, bStandingRedraw )
        {
            // DataTables 1.10 compatibility - if 1.10 then versionCheck exists.
            // 1.10s API has ajax reloading built in, so we use those abilities
            // directly.
            if ( $.fn.dataTable.versionCheck ) {
                var api = new $.fn.dataTable.Api( oSettings );

                if ( sNewSource ) {
                    api.ajax.url( sNewSource ).load( fnCallback, !bStandingRedraw );
                }
                else {
                    api.ajax.reload( fnCallback, !bStandingRedraw );
                }
                return;
            }

            if ( sNewSource !== undefined && sNewSource !== null ) {
                oSettings.sAjaxSource = sNewSource;
            }

            // Server-side processing should just call fnDraw
            if ( oSettings.oFeatures.bServerSide ) {
                this.fnDraw();
                return;
            }

            this.oApi._fnProcessingDisplay( oSettings, true );
            var that = this;
            var iStart = oSettings._iDisplayStart;
            var aData = [];

            this.oApi._fnServerParams( oSettings, aData );

            oSettings.fnServerData.call( oSettings.oInstance, oSettings.sAjaxSource, aData, function(json) {
                /* Clear the old information from the table */
                that.oApi._fnClearTable( oSettings );

                /* Got the data - add it to the table */
                var aData =  (oSettings.sAjaxDataProp !== "") ?
                        that.oApi._fnGetObjectDataFn( oSettings.sAjaxDataProp )( json ) : json;

                for ( var i=0 ; i<aData.length ; i++ )
                {
                    that.oApi._fnAddData( oSettings, aData[i] );
                }

                oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();

                that.fnDraw();

                if ( bStandingRedraw === true )
                {
                    oSettings._iDisplayStart = iStart;
                    that.oApi._fnCalculateEnd( oSettings );
                    that.fnDraw( false );
                }

                that.oApi._fnProcessingDisplay( oSettings, false );

                /* Callback user function - for event handlers etc */
                if ( typeof fnCallback === 'function' && fnCallback !== null )
                {
                    fnCallback( oSettings );
                }
            }, oSettings );
        };

        // Start off in milliseconds
        var timeUnitFactor = 1000000;

        // Column targets for the data table change if CPU is enabled;
        var columnTargets;
        if (DarkFeatures.isEnabled('confluence-monitoring.cpu.enable')) {
            columnTargets = [2, 3, 4, 5, 6, 7, 8, 9];
        }
        else {
            columnTargets = [2, 3, 4, 5];
        }


        //Configure the datatable
        var timersTable = $('#timersTable').dataTable({
            "bProcessing": true,
            "bServerSide": false,
            "sAjaxSource": '../rest/monitorstats/1.0/timers.json',
            "sDom": 'CT<"clear">lfrtip',
            "oTableTools": {
                "aButtons": [ "copy", "csv" ],
                "sSwfPath": "../plugins/servlet/monitoring-console-helper/swf"
            },
            "oColVis": {
                "aiExclude": [ 0, 1 ]
            },
            "aoColumnDefs": [
                { "sClass": "timer_name", "aTargets": [ 0 ] },
                {
                    // `data` refers to the data for the cell (defined by `mData`, which
                    // defaults to the column being worked with, in this case is the first
                    // Using `row[0]` is equivalent.
                    "mRender": function ( data, type, row ) {
                        if ((data === null) || isNaN(data)) {
                            return data;
                        }
                        return truncateDecimals(data / timeUnitFactor, 0);
                    },
                    "aTargets": columnTargets
                }
            ],
            "iDisplayLength": 25,
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
        });

        // Use the following to turn off columns from visibility
        // $.each([4, 6, 7, 9, 10, 11, 12], function(index, value) {
        //     timersTable.fnSetColumnVis( value, false );
        // });

        // Register to handle refreshes
        $('#btnRefresh').click(function(e) {
            e.preventDefault();
            timersTable.fnReloadAjax();
        });

        // Register to handle clear
        $('#btnClear').click(function(e) {
            e.preventDefault();
            // Post a delete operation and then refresh the table
            $.ajax({
                url: '../rest/monitorstats/1.0/timers.json',
                type: 'DELETE',
                success: function(result) {
                    timersTable.fnReloadAjax();
                },
                error: function() {
                    AJS.log('delete call failed');
                }
            });
        });

        // Register to handle change of time unit
        $('#selTimeUnit').change(function(e) {
            AJS.log('time unit changed: ' + e);
            AJS.log(e);
            AJS.log(e.target.selectedOptions[0].value);
            timeUnitFactor = parseInt(e.target.selectedOptions[0].value);
            AJS.log('timeUnitFactor = ' + timeUnitFactor);
            timersTable.fnReloadAjax();
        });
    }

    return MonitoringConsole;
});

require('confluence/module-exporter').safeRequire('confluence/monitoring-console', function(MonitoringConsole) {
    var AJS = require('ajs');

    AJS.toInit(MonitoringConsole);
});

