/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.monitoring;

import com.atlassian.cluster.monitoring.spi.model.Table;
import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStatisticSupplier
implements Supplier<Table> {
    private static final Logger log = LoggerFactory.getLogger(CacheStatisticSupplier.class);
    private static final String I18N_PREFIX = CacheStatisticSupplier.class.getCanonicalName();
    private final CacheStatisticsManager cacheStatisticsManager;
    private final I18NBean i18NBean;

    public CacheStatisticSupplier(CacheStatisticsManager cacheStatisticsManager, I18NBeanFactory i18NBeanFactory) {
        this.cacheStatisticsManager = (CacheStatisticsManager)Preconditions.checkNotNull((Object)cacheStatisticsManager);
        this.i18NBean = ((I18NBeanFactory)Preconditions.checkNotNull((Object)i18NBeanFactory)).getI18NBean();
    }

    public Table get() {
        log.debug("Getting cache stats");
        List allStats = this.cacheStatisticsManager.getLocalCacheStatistics();
        ImmutableMap columns = ImmutableMap.builder().put((Object)Column.NAME.key, (Object)this.i18NBean.getText(Column.NAME.i18nKey)).put((Object)Column.SIZE.key, (Object)this.i18NBean.getText(Column.SIZE.i18nKey)).put((Object)Column.MAX_SIZE.key, (Object)this.i18NBean.getText(Column.MAX_SIZE.i18nKey)).put((Object)Column.USAGE_PERCENT.key, (Object)this.i18NBean.getText(Column.USAGE_PERCENT.i18nKey)).put((Object)Column.HIT_COUNT.key, (Object)this.i18NBean.getText(Column.HIT_COUNT.i18nKey)).put((Object)Column.MISS_COUNT.key, (Object)this.i18NBean.getText(Column.MISS_COUNT.i18nKey)).put((Object)Column.HIT_PERCENT.key, (Object)this.i18NBean.getText(Column.HIT_PERCENT.i18nKey)).build();
        LinkedHashMap rows = Maps.newLinkedHashMap();
        for (CacheStatistics cacheStatistics : allStats) {
            rows.put(String.valueOf(cacheStatistics.getName()), ImmutableList.of((Object)cacheStatistics.getNiceName(), (Object)String.valueOf(cacheStatistics.getSize()), (Object)String.valueOf(cacheStatistics.getMaxSize()), (Object)(String.valueOf(cacheStatistics.getUsagePercent()) + '%'), (Object)String.valueOf(cacheStatistics.getHitCount()), (Object)String.valueOf(cacheStatistics.getMissCount()), (Object)(String.valueOf(cacheStatistics.getHitPercent()) + '%')));
        }
        return new Table((Map)columns, (Map)rows);
    }

    private static enum Column {
        NAME("name"),
        SIZE("size"),
        MAX_SIZE("maxSize"),
        USAGE_PERCENT("usagePercent"),
        HIT_COUNT("hitCount"),
        MISS_COUNT("missCount"),
        HIT_PERCENT("hitPercent");

        private final String key;
        private final String i18nKey;

        private Column(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.i18nKey = I18N_PREFIX + '.' + this.key;
        }
    }
}

