ConfluenceMobile.Notification = function ($anchorContainer) {

    // If you forget to call this with `new`, we won't unpack all our vars into the global object. It'll just *work* automagically.
    if (!(this instanceof ConfluenceMobile.Notification)) {
        return new ConfluenceMobile.Notification($anchorContainer);
    }

    this.$anchorContainer = $($anchorContainer);

    if (!this.$anchorContainer.length) {
        throw new Error("You must pass a container to place the notification in.");
    }

    this.$notification = $(Confluence.Templates.Mobile.Notifications.notifications());

    this.$notification
        .hide()
        .appendTo(this.$anchorContainer);

    this.$anchorContainer
        .css({
            position: "relative"
        });

    this._setDimensions();

}

ConfluenceMobile.Notification.prototype = {

    _setDimensions: function () {

        // Timeout because when the address bar is shifted in iOS,
        // the window height changes. By pushing this onto the
        // event queue, we guarantee that by the time it's run
        // the address bar has been shifted.
        setTimeout(function (obj) {
            var offset = obj.$anchorContainer.offset(),
                windowHeight = $(window).height(),
                tooTall = offset.height > windowHeight;

            if (!offset.height || tooTall) {
                offset.height = windowHeight - offset.top;
            }

            _.extend(offset, {
                top: 0,
                left: 0
            });

            obj.$notification.css(offset);

        }, 0, this);
    },


    // Convenience shortcut
    showLoading: function () {
        return this.showMessage(AJS.I18n.getText("confluence.mobile.loading"), true)
    },

    showMessage: function (message, throbber) {
        // Because we introduced a timeout to calculate the dimensions above,
        // we must also wrap this in a time out, otherwise a call to this
        // will execute before the dimensions are set and it won't look pretty.
        setTimeout(function (that) {
            that.$notification.find("span").text(message).toggleClass("throbber", !!throbber).end().show();
        }, 0, this);
    },

    hide: function (type) {
        return this.$notification.hide();
    },

    toggle: function () {
        return this.$notification.toggle.apply(this.$notification, arguments);
    },

    destroy: function () {
        this.$notification.remove();
        this.$anchorContainer.css({
            position: ""
        })
    }
};

