// TODO each new route so ensure that any previous models, views, etc are cleaned up. E.g. remove the PageView and it's objects and bindings when navigating to dashboard. 
Zepto(function($){
    ConfluenceMobile.Router = Backbone.Router.extend({
        routes:{
            "":"dashboard",
            "dashboard":"dashboard",
            "dashboard/:streamType":"dashboard",
            "dashboard/:streamType/:pageSize":"dashboard",
            "content/view/:contentId":"viewContent",
            "content/view/:contentId/:commentId":"viewContent",
            "profile/:username": "profile"
        },

        route: function (route, name, callback) {
            this.constructor.__super__.route.call(this, route, name, function () {
                this.trigger.apply(this, ["change"].concat(arguments));
                callback.apply(this, arguments);

                ConfluenceMobile.routerEventAggregator.trigger("change", route, name, arguments);
            });
        },

        dashboard: function (streamType, pageSize) {
            this._resetFixtures();
            if (!ConfluenceMobile.View.dashboard) {
                ConfluenceMobile.View.dashboard = new ConfluenceMobile.StreamFiltersView({
                    activeStreamType:streamType,
                    pageSize:pageSize
                });
            }

            ConfluenceMobile.View.dashboard.render();

            if (streamType) {
                ConfluenceMobile.View.dashboard.changeFilterView(streamType);
            }
        },
        
        viewContent: function (contentId, commentId) {
            // TODO The objects created here will need to be either tidied or reused as we navigate the app (to avoid leaking).
            // Note: The ConfluenceMobile.pageEventAggregator may not be necessary if we modify this such that a 'prototype' 
            // PageView always exists and is reconfigured as necessary. Plugin JS could bind directly to the PageView instead 
            // of the aggregator.
            this._resetFixtures();
            new ConfluenceMobile.PageView({
                contentId: contentId,
                commentId: commentId
            }).render();
        },

        profile: function (username) {
            this._resetFixtures();
            new ConfluenceMobile.viewProfileView({
                username: username
            });
            
            ConfluenceMobile.changeView("view-profile");
        },

        /**
         * Whenever we return to a Confluence route clean up any cruft a plugin may have added.
         * @private
         */
        _resetFixtures: function () {
            // Show confluence stuff and kill your stuff
            var inner = $('#inner-container');
            if (!inner.length) return;

            var ourStuff = inner.children('.header, .container').show();
            inner.children().not(ourStuff).remove();
            inner.removeClass();   // plugins may have added their own classes - nix 'em.
        }
    });

    ConfluenceMobile.router = new ConfluenceMobile.Router();

    ConfluenceMobile.pageEventAggregator.on("post-render", function () {
        /**
         * If this page was loaded previously, restore the position the user was at when they last viewed the page
         */
        ConfluenceMobile.Scrolling.restorePosition();

        // If you visit a tall page in Android's browser and then go back to a short page,
        // the browser reserves a void for the height of the previous page.
        // This fixes that.
        if ($.os.android) {
            var $body = $("body");
            $body.hide();
            setTimeout(function () {
                $body.show();
            }, 0);
        }
    });

    Backbone.history.start({ root: ConfluenceMobile.AppData.get("confluence-context-path") + "/plugins/servlet/mobile" });

    // Add some classes for the browser/environment type.
    // Browser sniffing sucks but so does Android.
    var platformsWeCareAbout = ["ios", "android"],
        prefix = "platform-",
        platformsDetected = platformsWeCareAbout
            .filter(function (platform) {
                return $.os.hasOwnProperty(platform);
            });

    if (platformsDetected.length) {
        $("body").addClass(prefix + platformsDetected.join(" " + prefix));
    }

});
