/**
 * A model representing a Confluence Page or Blog. 
 */
ConfluenceMobile.Content = Backbone.Model.extend({

    _requiredAttributes: ["title", "body", "author", "displayDate", "comments", "space"],

    initialize: function (attributes) {
        if (!attributes) {
            throw new Error("Attributes is required");
        }

        if (!attributes.id || attributes.id <= 0) {
            throw new Error("ID is required and must be greater than 0");
        }

        this.contentId = attributes.id;
    },

    parse: function(results) {
        var contentId = this.contentId;
        results.comments = results.comments.map(function (comment) {
            comment.ownerId = contentId;
            return comment;
        });
        results.contentId = contentId;
        return results;
    },

    validate: function (attributes, options) {
        _.each(this._requiredAttributes, function (requiredAttribute) {
            // Capture cases of `null` or `undefined` (void 0 is a safe way of getting `undefined`, which may be redefined).
            if (attributes[requiredAttribute] == void 0) {
                throw new Error("'" + requiredAttribute + "' is missing"); // fail-fast to allow devs quickly catch a change in the REST resource not serving required data (no friendly front-end message required)
            }
        });
    },

    sync: function(method, model, options) {
        if (method == "read") {
            return ConfluenceMobile.ContentLoader.load(this.contentId, options.success, options.error);
        }
        
        // the default behaviour for all other methods
        Backbone.sync.call(this, arguments);
    }    
});