ConfluenceMobile.Stream = Backbone.Collection.extend({
    model: ConfluenceMobile.StreamItem,
    url: function() {
        if (this.streamType == "popular") {
            return this.contextPath + "/rest/popular/1/stream/content?urlStrategy=mobile&edgeTypes=page.create,blogpost.create,comment.create,like.create";
        } else {
            return this.contextPath + "/rest/mobile/1.0/stream/" + this.streamType;            
        }
    },
    initialize: function(models, options) {
        options = options || {};
        this.streamType = options.streamType;
        this.contextPath = options.contextPath || "";
    },
    parse: function(response) {
        this.nextPageOffset = response.nextPageOffset;
        this.token = response.token;

        return response.streamItems;
    }
});
