(function ($) {

    AJS.test.require("com.atlassian.confluence.plugins.confluence-mobile:like-resources");

    var likesCollectionOptions = {
            contentId: 123,
            contextPath: "/confluence"
        },
        user = { userName: "Egg McLaren" };

    module("like collection starting empty", {
        setup:function () {
            this.collection = new ConfluenceMobile.Likes(null, likesCollectionOptions);
        }
    });

    test("test add current user", function () {
        this.collection.addUser(user.userName);
        equal(this.collection.at(0).get("username"), user.userName, "Expect first item in collection to be the current user.");

    });

    test("test does current user like this", function () {
        this.collection.addUser(user.userName);
        equal(this.collection.doesUserLikeThis(user.userName), true, "Expect current user in collection.");
    });

    test("test remove current user", function () {
        this.collection.addUser(user.userName);
        this.collection.removeUser(user.userName);
        equal(this.collection.length, 0, "Expect no models in collection.");
    });

    module("like collection with existing user like", {
        setup:function () {
            this.collection = new ConfluenceMobile.Likes([
                { username:"dave" },
                { username:"alex" }
            ], likesCollectionOptions);
        }
    });

    test("test does user like this with valid user", function () {
        ok(this.collection.doesUserLikeThis("dave"), "dave is in collection.");
        ok(this.collection.doesUserLikeThis("alex"), "alex is in collection.");
    });

    test("test does user like this with invalid user", function () {
        ok(!this.collection.doesUserLikeThis("fred"), "fred is not in the collection");
    });

})(jQuery);