/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.rest;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.mobile.rest.RecentContentDto;
import com.atlassian.confluence.plugins.mobile.rest.StreamResourceInterface;
import com.atlassian.confluence.plugins.mobile.search.CreatorsSearchFilter;
import com.atlassian.confluence.plugins.rest.dto.StreamItem;
import com.atlassian.confluence.plugins.rest.dto.UserDtoFactory;
import com.atlassian.confluence.plugins.rest.manager.DateEntityFactory;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.DefaultSearchWithToken;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.SearchTokenExpiredException;
import com.atlassian.confluence.search.v2.SearchWithToken;
import com.atlassian.confluence.search.v2.query.AllQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.searchfilter.ChainedSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/stream")
public class StreamResource
implements StreamResourceInterface {
    private static final Logger log = LoggerFactory.getLogger(StreamResource.class);
    private static final int ITEMS_PER_PAGE = 10;
    private final SearchManager searchManager;
    private final TransactionTemplate transactionTemplate;
    private final UserDtoFactory userDtoFactory;
    private final DateEntityFactory dateEntityFactory;
    private final LikeManager likeManager;
    private final FollowManager followManager;
    private final ContextPathHolder contextPathHolder;
    private final I18nResolver i18nResolver;

    public StreamResource(SearchManager searchManager, TransactionTemplate transactionTemplate, UserDtoFactory userDtoFactory, DateEntityFactory dateEntityFactory, LikeManager likeManager, ContextPathHolder contextPathHolder, FollowManager followManager, I18nResolver i18nResolver) {
        this.searchManager = searchManager;
        this.transactionTemplate = transactionTemplate;
        this.userDtoFactory = userDtoFactory;
        this.dateEntityFactory = dateEntityFactory;
        this.likeManager = likeManager;
        this.followManager = followManager;
        this.contextPathHolder = contextPathHolder;
        this.i18nResolver = i18nResolver;
    }

    @Override
    @GET
    @Path(value="/recentblogs")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public RecentContentDto getRecentlyAddedBlogs(@QueryParam(value="nextPageOffset") @DefaultValue(value="0") int nextPageOffset, @QueryParam(value="urlStrategy") @DefaultValue(value="desktop") String urlStrategy, @QueryParam(value="token") @DefaultValue(value="0") long searchToken) {
        ISearch search = this.getRecentlyAddedBlogsSearch(nextPageOffset);
        return this.getSearchResults(search, searchToken);
    }

    @Override
    @GET
    @Path(value="/network")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public RecentContentDto getRecentlyAddedFromNetwork(@QueryParam(value="nextPageOffset") @DefaultValue(value="0") int nextPageOffset, @QueryParam(value="urlStrategy") @DefaultValue(value="desktop") String urlStrategy, @QueryParam(value="token") @DefaultValue(value="0") long searchToken) {
        ISearch search = this.getRecentlyAddedFromNetworkSearch(nextPageOffset);
        return this.getSearchResults(search, searchToken);
    }

    private RecentContentDto getSearchResults(final ISearch search, final long searchToken) {
        final RecentContentDto result = new RecentContentDto();
        List streamItems = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<StreamItem>>(){

            public List<StreamItem> doInTransaction() {
                SearchResults searchResults;
                if (searchToken > 0L) {
                    try {
                        searchResults = StreamResource.this.searchManager.search((SearchWithToken)new DefaultSearchWithToken(search, searchToken));
                    }
                    catch (SearchTokenExpiredException e) {
                        log.debug("search token expired.", (Throwable)e);
                        throw new WebApplicationException(Response.status((int)500).entity(Collections.singletonMap("message", StreamResource.this.i18nResolver.getText("confluence.mobile.stream.loading.token.expired"))).build());
                    }
                    catch (InvalidSearchException e) {
                        log.error("Invalid search", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                try {
                    searchResults = StreamResource.this.searchManager.search(search);
                }
                catch (InvalidSearchException e) {
                    log.error("Invalid search", (Throwable)e);
                    return Collections.emptyList();
                }
                List searchables = StreamResource.this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION);
                LinkedList<StreamItem> streamItems = new LinkedList<StreamItem>();
                LinkedList<ContentEntityObject> contentEntities = new LinkedList<ContentEntityObject>();
                for (Searchable searchable : searchables) {
                    if (!(searchable instanceof ContentEntityObject)) continue;
                    contentEntities.add((ContentEntityObject)searchable);
                }
                if (searchResults.getNextPageSearch() != null) {
                    result.setNextPageOffset(searchResults.getNextPageSearch().getStartOffset());
                    result.setToken(searchResults.getNextPageSearch().getSearchToken());
                }
                Map likes = StreamResource.this.likeManager.getLikes(contentEntities);
                for (ContentEntityObject contentEntity : contentEntities) {
                    int numberOfLikes = likes.containsKey(contentEntity.getId()) ? ((List)likes.get(contentEntity.getId())).size() : 0;
                    streamItems.add(new StreamItem(contentEntity.getId(), contentEntity.getDisplayTitle(), StreamResource.this.getUrl(contentEntity), StreamResource.this.userDtoFactory.getUserDto(contentEntity.getCreatorName()), StreamResource.this.dateEntityFactory.buildDateEntity(contentEntity.getCreationDate()).getFriendly(), numberOfLikes, 0));
                }
                return streamItems;
            }
        });
        result.setStreamItems(streamItems);
        return result;
    }

    private ISearch getRecentlyAddedBlogsSearch(int startOffset) {
        ArrayList<SiteSearchPermissionsSearchFilter> searchFilters = new ArrayList<SiteSearchPermissionsSearchFilter>();
        searchFilters.add(SiteSearchPermissionsSearchFilter.getInstance());
        HashSet<Object> queries = new HashSet<Object>();
        queries.add(AllQuery.getInstance());
        queries.add(new ContentTypeQuery(EnumSet.of(ContentTypeEnum.BLOG)));
        return new ContentSearch(BooleanQuery.composeAndQuery(queries), (SearchSort)CreatedSort.DESCENDING, (SearchFilter)new ChainedSearchFilter(searchFilters, ChainedSearchFilter.Operator.AND), startOffset, 10);
    }

    private ISearch getRecentlyAddedFromNetworkSearch(int startOffset) {
        ArrayList<Object> searchFilters = new ArrayList<Object>();
        searchFilters.add(SiteSearchPermissionsSearchFilter.getInstance());
        Set following = this.followManager.getFollowing(AuthenticatedUserThreadLocal.get());
        searchFilters.add((Object)new CreatorsSearchFilter(following));
        HashSet<Object> queries = new HashSet<Object>();
        queries.add(AllQuery.getInstance());
        queries.add(new ContentTypeQuery(EnumSet.of(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG, ContentTypeEnum.COMMENT)));
        return new ContentSearch(BooleanQuery.composeAndQuery(queries), (SearchSort)CreatedSort.DESCENDING, (SearchFilter)new ChainedSearchFilter(searchFilters, ChainedSearchFilter.Operator.AND), startOffset, 10);
    }

    private String getUrl(ContentEntityObject contentEntity) {
        if (contentEntity instanceof Comment) {
            Comment comment = (Comment)contentEntity;
            ContentEntityObject owningContent = comment.getOwner();
            return this.contextPathHolder.getContextPath() + "/plugins/servlet/mobile#content/view/" + owningContent.getId() + "/" + comment.getId();
        }
        return this.contextPathHolder.getContextPath() + "/plugins/servlet/mobile#content/view/" + contentEntity.getId();
    }
}

