/**
 * Autocomplete dropdown appears when you press a trigger character in the editor.
 */
(function($) {

    AJS.EventQueue = AJS.EventQueue || [];

    function activateMentions() {
        AJS.EventQueue.push({name: 'confluencementioninsert'});
        Confluence.Editor.Autocompleter.Manager.shortcutFired("@", true);
    }

    function isAtKey(event) {
        return event &&
            event.shiftKey &&
            !event.ctrlKey && !event.altKey && !event.altGraphKey && !event.metaKey &&
            event.which === 64;
    }

    tinymce.create('tinymce.plugins.InsertMention', {

        init : function(ed) {

            $('#insertmention-button').click(function(evt){
                evt.stopPropagation();
                evt.preventDefault();

                var inputDrivenDropdown = Confluence.Editor.Autocompleter.Manager.getInputDrivenDropdown();
                if (!inputDrivenDropdown || inputDrivenDropdown.inactive) {
                    tinymce.execCommand('mceFocus',false, ed.id);
                    activateMentions();
                }
            });

            AJS.bind('editor.text-placeholder.activated', function(e, data) {
                if(data && data.placeholderType === "mention") {
                    if(isAtKey(data.triggerEvent)) {
                        // Avoid 2nd @
                        tinymce.dom.Event.cancel(data.triggerEvent);
                    }
                    activateMentions();
                }
            });

            if(AJS.Rte.Placeholder && AJS.Rte.Placeholder.addPlaceholderType)
                AJS.Rte.Placeholder.addPlaceholderType({
                    type: 'mention',
                    label: AJS.I18n.getText("property.panel.textplaceholder.display.mention"),
                    tooltip: AJS.I18n.getText("property.panel.textplaceholder.display.mention.tooltip")
                });
        },

        getInfo : function() {
            return {
                longname : 'Insert Mention',
                author : 'Atlassian',
                authorurl : 'http://www.atlassian.com',
                version : tinymce.majorVersion + "." + tinymce.minorVersion
            };
        }
    });

    tinymce.PluginManager.add('insertmention', tinymce.plugins.InsertMention);
})(AJS.$);

AJS.Rte.BootstrapManager.addTinyMcePluginInit(function(settings) {
    settings.plugins += ",insertmention";
});