/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.ContentRetriever;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryBuilder;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryParameters;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryRenderingStrategy;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.extra.masterdetail.entities.PaginatedDetailLines;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.StreamableMacro;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.plugins.createcontent.api.services.CreateButtonService;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class DetailsSummaryMacro
extends BaseMacro
implements StreamableMacro {
    public static final String PARAM_ID = "id";
    private static final String PARAM_SHOW_COMMENTS_COUNT = "showCommentsCount";
    private static final String PARAM_SHOW_LIKES_COUNT = "showLikesCount";
    static final String PARAM_PAGE_SIZE = "pageSize";
    private static final String PARAM_SORT_BY = "sortBy";
    private static final String PARAM_REVERSE_SORT = "reverseSort";
    private static final String PARAM_HEADINGS = "headings";
    private static final String TEMPLATE_PARAM_TOTAL_PAGES = "totalPages";
    private static final String TEMPLATE_PARAM_CURRENT_PAGE = "currentPage";
    private static final String TEMPLATE_PARAM_PAGE_SIZE = "pageSize";
    private static final String TEMPLATE_PARAM_LABEL = "label";
    private static final String TEMPLATE_PARAM_CQL = "cql";
    private static final String TEMPLATE_PARAM_HEADINGS = "headings";
    private static final String TEMPLATE_PARAM_DETAILS = "details";
    private static final String TEMPLATE_PARAM_BLUEPRINT_PRESENT = "blueprintPresent";
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final int MAX_PAGESIZE = 1000;
    public static final int PARAM_ID_MAX_LENGTH = 256;
    private final XhtmlContent xhtmlContent;
    private final PageBuilderService pageBuilderService;
    private final I18nResolver i18nResolver;
    private final ContentRetriever contentRetriever;
    private final DetailsSummaryBuilder detailsSummaryBuilder;
    private final SpaceManager spaceManager;
    private final TemplateRenderer templateRenderer;
    private final CreateButtonService createButtonService;
    private final EventPublisher eventPublisher;

    public DetailsSummaryMacro(I18nResolver i18nResolver, XhtmlContent xhtmlContent, SpaceManager spaceManager, PageBuilderService pageBuilderService, CreateButtonService createButtonService, ContentRetriever contentRetriever, DetailsSummaryBuilder detailsSummaryBuilder, TemplateRenderer templateRenderer, EventPublisher eventPublisher) {
        this.xhtmlContent = xhtmlContent;
        this.pageBuilderService = pageBuilderService;
        this.templateRenderer = templateRenderer;
        this.createButtonService = createButtonService;
        this.contentRetriever = contentRetriever;
        this.i18nResolver = i18nResolver;
        this.detailsSummaryBuilder = detailsSummaryBuilder;
        this.spaceManager = spaceManager;
        this.eventPublisher = eventPublisher;
    }

    public String execute(Map macroParameters, String bodyWikiMarkup, RenderContext renderContext) {
        ArrayList wikiMarkupToStorageConversionErrors = Lists.newArrayList();
        DefaultConversionContext conversionContext = new DefaultConversionContext(renderContext);
        String storageFormatBody = this.xhtmlContent.convertWikiToStorage(bodyWikiMarkup, (ConversionContext)conversionContext, (List)wikiMarkupToStorageConversionErrors);
        return this.execute((Map<String, String>)macroParameters, storageFormatBody, (ConversionContext)conversionContext);
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) {
        return Streamables.writeToString((Streamable)this.executeToStream(parameters, Streamables.from((String)body), context));
    }

    public Streamable executeToStream(Map<String, String> macroParameters, Streamable body, ConversionContext conversionContext) {
        try {
            this.validateContextOwner(conversionContext);
            String id = macroParameters.get(PARAM_ID);
            if (id != null && id.length() > 256) {
                throw new MacroExecutionException(this.i18nResolver.getText("details.error.id.length"));
            }
            DetailsSummaryMacroMetricsEvent.Builder metrics = DetailsSummaryMacroMetricsEvent.builder(DetailsSummaryMacroMetricsEvent.Type.MACRO_EXECUTION).macroOutputType(conversionContext.getOutputType());
            return this.streamResponse(metrics, this.buildTemplateModel(macroParameters, conversionContext, metrics));
        }
        catch (MacroExecutionException e) {
            return Streamables.from((String)RenderUtils.blockError((String)e.getMessage(), (String)""));
        }
    }

    private Streamable streamResponse(final DetailsSummaryMacroMetricsEvent.Builder metrics, final Map<String, Object> templateModel) {
        this.pageBuilderService.assembler().resources().requireWebResource("confluence.extra.masterdetail:master-details-resources");
        return new Streamable(){

            public void writeTo(Writer writer) throws IOException {
                metrics.templateRenderStart();
                DetailsSummaryMacro.this.templateRenderer.renderTo((Appendable)writer, "confluence.extra.masterdetail:master-details-resources", "Confluence.Templates.Macro.MasterDetail.detailsSummary.soy", templateModel);
                metrics.templateRenderFinish();
                DetailsSummaryMacro.this.eventPublisher.publish((Object)metrics.build());
            }
        };
    }

    Map<String, Object> buildTemplateModel(Map<String, String> macroParameters, ConversionContext conversionContext, DetailsSummaryMacroMetricsEvent.Builder metrics) throws MacroExecutionException {
        Space currentSpace = this.spaceManager.getSpace(conversionContext.getSpaceKey());
        if (currentSpace == null) {
            throw new MacroExecutionException("ConversionContext returned invalid space key '" + conversionContext.getSpaceKey() + "'");
        }
        DetailsSummaryRenderingStrategy renderingStrategy = DetailsSummaryRenderingStrategy.strategyFor(conversionContext, ServletContextThreadLocal.getRequest());
        String cql = macroParameters.get(TEMPLATE_PARAM_CQL);
        SearchContext searchContext = conversionContext.getPageContext().toSearchContext().build();
        boolean reverseSort = this.getBooleanParam(macroParameters, PARAM_REVERSE_SORT);
        List<ContentEntityObject> content = new ArrayList<ContentEntityObject>();
        if (renderingStrategy == DetailsSummaryRenderingStrategy.SERVER_SIDE) {
            content = this.contentRetriever.getContentWithMetaData(cql, reverseSort, searchContext, metrics);
        }
        DetailsSummaryParameters params = this.getDetailsSummaryParameters(macroParameters, content, renderingStrategy, conversionContext);
        PaginatedDetailLines paginatedDetailLines = this.getPaginatedDetailLines(renderingStrategy, metrics, params, conversionContext.getOutputType());
        BlueprintParameters blueprint = new BlueprintParameters(macroParameters, currentSpace);
        return this.buildTemplateModel(macroParameters, paginatedDetailLines, params, blueprint);
    }

    private DetailsSummaryParameters getDetailsSummaryParameters(Map<String, String> macroParameters, List<ContentEntityObject> content, DetailsSummaryRenderingStrategy renderingStrategy, ConversionContext conversionContext) throws MacroExecutionException {
        boolean currentPage = false;
        int pageSize = ConversionContextOutputType.PDF.value().equals(conversionContext.getOutputType()) || ConversionContextOutputType.WORD.value().equals(conversionContext.getOutputType()) || ConversionContextOutputType.HTML_EXPORT.value().equals(conversionContext.getOutputType()) ? 1000 : renderingStrategy.calculatePageSize(macroParameters);
        String id = macroParameters.get(PARAM_ID);
        if (id != null && id.length() > 256) {
            throw new MacroExecutionException(this.i18nResolver.getText("details.error.id.length"));
        }
        boolean countComments = this.getBooleanParam(macroParameters, PARAM_SHOW_COMMENTS_COUNT);
        boolean countLikes = this.getBooleanParam(macroParameters, PARAM_SHOW_LIKES_COUNT);
        String sortBy = macroParameters.get(PARAM_SORT_BY);
        boolean reverseSort = this.getBooleanParam(macroParameters, PARAM_REVERSE_SORT);
        String headings = macroParameters.get("headings");
        return new DetailsSummaryParameters().setPageSize(pageSize).setCurrentPage(0).setCountComments(countComments).setCountLikes(countLikes).setHeadingsString(headings).setSortBy(sortBy).setReverseSort(reverseSort).setContent(content).setId(id);
    }

    private PaginatedDetailLines getPaginatedDetailLines(DetailsSummaryRenderingStrategy renderingStrategy, DetailsSummaryMacroMetricsEvent.Builder metrics, DetailsSummaryParameters params, String outputType) {
        if (renderingStrategy == DetailsSummaryRenderingStrategy.SERVER_SIDE) {
            return this.detailsSummaryBuilder.getPaginatedDetailLines(params, false, metrics, outputType);
        }
        return null;
    }

    private Map<String, Object> buildTemplateModel(Map<String, String> macroParameters, @Nullable PaginatedDetailLines paginatedDetailLines, DetailsSummaryParameters params, BlueprintParameters blueprint) {
        HashMap model = Maps.newHashMap();
        String firstColumnParam = macroParameters.get("firstcolumn");
        String firstColumnHeading = StringUtils.isBlank((CharSequence)firstColumnParam) ? this.i18nResolver.getText("detailssummary.heading.title") : firstColumnParam;
        model.put("firstColumnHeading", firstColumnHeading);
        model.put(TEMPLATE_PARAM_CQL, macroParameters.get(TEMPLATE_PARAM_CQL));
        model.put(TEMPLATE_PARAM_LABEL, macroParameters.get(TEMPLATE_PARAM_LABEL));
        model.put("macroHeadings", macroParameters.get("headings"));
        if (paginatedDetailLines != null) {
            model.put("renderedHeadings", paginatedDetailLines.getRenderedHeadings());
            model.put(TEMPLATE_PARAM_DETAILS, paginatedDetailLines.getDetailLines());
        }
        model.put(PARAM_SORT_BY, params.getSortBy());
        model.put(PARAM_ID, macroParameters.get(PARAM_ID));
        model.put(PARAM_REVERSE_SORT, params.isReverseSort());
        model.put("analyticsKey", macroParameters.get("analytics-key"));
        model.put(PARAM_SHOW_COMMENTS_COUNT, this.getBooleanParam(macroParameters, PARAM_SHOW_COMMENTS_COUNT));
        model.put(PARAM_SHOW_LIKES_COUNT, this.getBooleanParam(macroParameters, PARAM_SHOW_LIKES_COUNT));
        model.put(TEMPLATE_PARAM_TOTAL_PAGES, params.getTotalPages());
        model.put(TEMPLATE_PARAM_CURRENT_PAGE, params.getCurrentPage());
        model.put("pageSize", params.getPageSize());
        model.put(TEMPLATE_PARAM_BLUEPRINT_PRESENT, blueprint.isPresent());
        if (blueprint.isPresent()) {
            blueprint.decorate(model);
        }
        return model;
    }

    private void validateContextOwner(ConversionContext conversionContext) throws MacroExecutionException {
        ContentEntityObject owner = conversionContext.getEntity();
        if (!(owner instanceof SpaceContentEntityObject) && !(owner instanceof Draft)) {
            throw new MacroExecutionException(this.i18nResolver.getText("detailssummary.error.must.be.inside.space"));
        }
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private boolean getBooleanParam(Map<String, String> macroParams, String paramName) {
        return Boolean.parseBoolean(macroParams.get(paramName));
    }

    private Space getCurrentSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }

    private class BlueprintParameters {
        private final Map<String, String> macroParameters;
        private final Space currentSpace;
        private final String blueprintModuleCompleteKey;
        private final String contentBlueprintId;

        private BlueprintParameters(Map<String, String> macroParameters, Space currentSpace) {
            this.macroParameters = macroParameters;
            this.currentSpace = currentSpace;
            this.blueprintModuleCompleteKey = StringUtils.trimToEmpty((String)macroParameters.get("blueprintModuleCompleteKey"));
            this.contentBlueprintId = StringUtils.trimToEmpty((String)macroParameters.get("contentBlueprintId"));
        }

        boolean isPresent() {
            return StringUtils.isNotBlank((CharSequence)this.blueprintModuleCompleteKey) || StringUtils.isNotBlank((CharSequence)this.contentBlueprintId);
        }

        void decorate(Map<String, Object> model) {
            model.put(DetailsSummaryMacro.TEMPLATE_PARAM_BLUEPRINT_PRESENT, true);
            model.put("blankTitle", this.macroParameters.get("blankTitle"));
            model.put("blankDescription", this.macroParameters.get("blankDescription"));
            model.put("blueprintModuleKey", new ModuleCompleteKey(this.blueprintModuleCompleteKey).getModuleKey());
            model.put("createFromTemplateHtml", DetailsSummaryMacro.this.createButtonService.renderBlueprintButton(this.currentSpace, this.contentBlueprintId, this.blueprintModuleCompleteKey, this.macroParameters.get("createButtonLabel"), null));
        }
    }
}

