/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.StreamableMacro;
import com.atlassian.confluence.macro.StreamableMacroAdapter;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class DetailsMacro
extends BaseMacro
implements StreamableMacro {
    public static final String MASTERDETAIL_RESOURCES = "confluence.extra.masterdetail:master-details-resources";
    private final PageBuilderService pageBuilderService;
    private final I18nResolver i18nResolver;

    public DetailsMacro(PageBuilderService pageBuilderService, I18nResolver i18nResolver) {
        this.pageBuilderService = pageBuilderService;
        this.i18nResolver = i18nResolver;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)parameters, body, (ConversionContext)new DefaultConversionContext(renderContext));
        }
        catch (MacroExecutionException macroError) {
            throw new MacroException((Throwable)macroError);
        }
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public boolean hasBody() {
        return true;
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    public Streamable executeToStream(Map<String, String> parameters, final Streamable body, ConversionContext context) throws MacroExecutionException {
        String id = parameters.get("id");
        if (id != null && id.length() > 256) {
            return Streamables.from((String)RenderUtils.blockError((String)this.i18nResolver.getText("details.error.id.length"), (String)""));
        }
        if (!BooleanUtils.toBoolean((String)parameters.get("hidden"))) {
            this.pageBuilderService.assembler().resources().requireWebResource(MASTERDETAIL_RESOURCES);
            return new Streamable(){

                public void writeTo(Writer writer) throws IOException {
                    writer.write("<div class='plugin-tabmeta-details'>");
                    body.writeTo(writer);
                    writer.write("</div>");
                }
            };
        }
        return Streamables.empty();
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        return StreamableMacroAdapter.executeFromStream((StreamableMacro)this, parameters, (String)body, (ConversionContext)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

