/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.content;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.mail.address.ConfluenceMailAddress;
import com.atlassian.confluence.mail.archive.Mail;
import com.atlassian.confluence.mail.archive.content.ContentBackedMail;
import com.atlassian.confluence.rss.AbstractContentEntityRenderSupport;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.util.concurrent.Timeout;
import java.util.Map;

public class MailFeedSupport
extends AbstractContentEntityRenderSupport<CustomContentEntityObject> {
    private Mail getMail(RssRenderItem item) {
        return ContentBackedMail.newInstance((CustomContentEntityObject)item.getEntity());
    }

    public String getTitle(RssRenderItem<? extends CustomContentEntityObject> item) {
        Mail mail = this.getMail(item);
        return mail.getSubject() + " " + this.getText("rss.template.from") + ": " + this.getSender(mail);
    }

    public String getRenderedContent(RssRenderItem<? extends CustomContentEntityObject> item, Timeout timeout) {
        Mail mail = this.getMail(item);
        Map contextMap = this.getContextMap(item, timeout);
        contextMap.put("entity", mail.getEntity());
        contextMap.put("mail", mail);
        contextMap.put("content", GeneralUtil.plain2html((String)mail.getMessageBody()));
        return VelocityUtils.getRenderedTemplate((String)"templates/mail-archive/rss/mail-rss-content.vm", (Map)contextMap);
    }

    public String getSender(Mail mail) {
        ConfluenceMailAddress address = mail.getFrom();
        return this.getSender(address);
    }

    public String getSender(ConfluenceMailAddress address) {
        if (address == null) {
            return this.getText("anonymous.name");
        }
        try {
            return address.getSender();
        }
        catch (Exception e) {
            return this.getText("invalid.email.address");
        }
    }
}

