/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.actions;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.mail.address.ConfluenceMailAddress;
import com.atlassian.confluence.mail.archive.MailHelper;
import com.atlassian.confluence.mail.archive.actions.AbstractMailAction;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.user.User;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveMailAction
extends AbstractMailAction {
    private static final Logger log = LoggerFactory.getLogger(RemoveMailAction.class);
    private ConfluenceIndexer indexer;
    private MailHelper mailHelper = new MailHelper();

    public String doRemove() throws Exception {
        log.debug("starting mail removal");
        this.getMail().getEntity().trash();
        log.debug("trashed mail.  Unindexing mail...");
        this.unIndex((EntityObject)this.getMail().getEntity());
        log.debug("Mail unindexed.");
        return "success";
    }

    public String execute() throws Exception {
        return "success";
    }

    private void unIndex(EntityObject eo) {
        if (this.indexer != null && eo instanceof Searchable) {
            Iterator it = ((Searchable)eo).getSearchableDependants().iterator();
            while (it.hasNext()) {
                this.unIndex((EntityObject)it.next());
            }
            this.indexer.unIndex((Searchable)eo);
        }
    }

    public ConfluenceIndexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public String getSender(ConfluenceMailAddress address) {
        return this.mailHelper.getSender(address);
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.REMOVE, (Object)this.getMail());
    }
}

