/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macrousage.extractor;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.macrousage.extractor.MacroCollector;
import com.atlassian.confluence.plugins.macrousage.extractor.MacroUsage;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExtractor
implements Extractor {
    private static final Logger log = LoggerFactory.getLogger(MacroExtractor.class);
    private final XhtmlContent xhtmlContent;
    private final MacroManager macroManager;
    private final Function<MacroUsage, Field> macroToNameField = macro -> new Field("macroName", macro.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
    private final Function<MacroUsage, Field> macroToVersionField = macro -> new Field("macroStorageVersion", macro.getStorageVersion() + "_" + macro.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);

    public MacroExtractor(XhtmlContent xhtmlContent, MacroManager macroManager) {
        this.xhtmlContent = xhtmlContent;
        this.macroManager = macroManager;
    }

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        this.addFields(searchable, arg_0 -> ((Document)document).add(arg_0));
    }

    @VisibleForTesting
    @Internal
    void addFields(Searchable searchable, Consumer<Field> addFieldToDocument) {
        log.debug("MacroExtractor:addFields called");
        if (!(searchable instanceof ContentEntityObject)) {
            return;
        }
        ContentEntityObject ceo = (ContentEntityObject)searchable;
        MacroCollector collector = new MacroCollector(this.macroManager);
        BodyType bodyType = ceo.getBodyContent().getBodyType();
        if (bodyType.equals((Object)BodyType.XHTML)) {
            this.processXhtml(ceo, collector);
        } else if (bodyType.equals((Object)BodyType.WIKI)) {
            collector.processPotentialWikiMacro(ceo.getBodyAsString());
        }
        List<MacroUsage> macroUsages = collector.getMacroUsages();
        macroUsages.stream().map(this.macroToNameField).forEach(addFieldToDocument);
        macroUsages.stream().map(this.macroToVersionField).forEach(addFieldToDocument);
    }

    void processXhtml(ContentEntityObject searchableCeo, MacroDefinitionHandler macroUsageCollector) {
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)searchableCeo.toPageContext());
        try {
            this.xhtmlContent.handleMacroDefinitions(searchableCeo.getBodyAsString(), (ConversionContext)context, macroUsageCollector);
        }
        catch (XhtmlException ex) {
            log.warn("Failed to extracting macro usages on entity [{}] : {}", (Object)searchableCeo.getId(), (Object)ex.getMessage());
            log.debug("Failed to extracting macro usages on entity [{}] : {}", (Object)searchableCeo.getId(), (Object)ex);
        }
    }
}

