/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macrousage.extractor;

import com.atlassian.confluence.plugins.macrousage.extractor.MacroUsage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.renderer.v2.WikiMarkupParser;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentHandler;
import com.atlassian.renderer.v2.macro.MacroManager;
import java.util.ArrayList;
import java.util.List;

class MacroCollector
implements MacroDefinitionHandler,
WikiContentHandler {
    private final List<MacroUsage> macroUsages = new ArrayList<MacroUsage>();
    private final MacroManager macroManager;

    MacroCollector(MacroManager macroManager) {
        this.macroManager = macroManager;
    }

    public void handle(MacroDefinition md) {
        this.macroUsages.add(new MacroUsage(md.getName(), md.getDefaultParameterValue(), md.getStorageVersion()));
        if (md.getName().equals("unmigrated-wiki-markup")) {
            this.processPotentialWikiMacro(md.getBodyText());
        }
    }

    public List<MacroUsage> getMacroUsages() {
        return this.macroUsages;
    }

    public void handleMacro(StringBuffer buffer, MacroTag macroTag, String body) {
        this.macroUsages.add(new MacroUsage(macroTag.command, null, "0"));
        if (body != null) {
            this.processPotentialWikiMacro(body);
        }
    }

    public void handleText(StringBuffer buffer, String s) {
    }

    void processPotentialWikiMacro(String wiki) {
        WikiMarkupParser parser = new WikiMarkupParser(this.macroManager, (WikiContentHandler)this);
        parser.parse(wiki);
    }
}

