/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.lookandfeel.filter;

import com.atlassian.confluence.plugins.lookandfeel.SiteLogo;
import com.atlassian.confluence.plugins.lookandfeel.SiteLogoManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogoInterceptor
implements Filter {
    private static final String CONFLUENCE_LOGO = "confluence-logo.png";
    private FilterConfig filterConfig;
    private final SiteLogoManager siteLogoManager;

    public LogoInterceptor(SiteLogoManager siteLogoManager) {
        this.siteLogoManager = siteLogoManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            SiteLogo siteLogo;
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String requestURL = req.getRequestURL().toString();
            if (requestURL.endsWith(CONFLUENCE_LOGO) && this.siteLogoManager.useCustomLogo() && (siteLogo = this.siteLogoManager.getCurrent()) != null) {
                this.filterConfig.getServletContext().getRequestDispatcher(siteLogo.getDownloadPath()).forward(request, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

