/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.lookandfeel;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.pages.thumbnail.renderer.AdaptiveThresholdPredicate;
import com.atlassian.confluence.pages.thumbnail.renderer.ThumbnailRenderer;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;

public class ImageScaler {
    public static final String TEMP_DIR = "scaledImages";
    private final Thumber thumber = new Thumber(Thumbnail.MimeType.PNG);
    private final ThumbnailRenderer thumbnailRenderer = new ThumbnailRenderer(this.thumber, (Predicate)new AdaptiveThresholdPredicate());

    public File scaleImageToMaxHeight(File file, int maxHeight) throws IOException {
        File outputFile = new File(this.getDirectoryForScaledImages(), file.getName());
        this.thumbnailRenderer.createThumbnail(file, outputFile, Integer.MAX_VALUE, maxHeight);
        return outputFile;
    }

    private File getDirectoryForScaledImages() {
        File dir = new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"), TEMP_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

