define('confluence-link-browser/tinymce/editor_plugin_src', [
    'tinymce',
    'confluence/legacy'
], function(
    tinymce,
    Confluence
) {
    "use strict";

    return {
        init : function(ed) {
            var LinkBrowser = Confluence.Editor.LinkBrowser;
            ed.addButton("linkbrowserButton", {title: "confluence.conflink_desc", cmd: "mceConflink", "class": "mce_conflink" });

            ed.addCommand('mceConflink', LinkBrowser.open);

            ed.addCommand('mceConfAttachments', function () {
                return LinkBrowser.open({
                    panelKey: LinkBrowser.ATTACHMENTS_PANEL
                });
            }); // attachments item in insert menu
        },
        getInfo : function () {
            return {
                longname : "Confluence Link Browser",
                author : "Atlassian",
                authorurl : "http://www.atlassian.com",
                version : tinymce.majorVersion + "." + tinymce.minorVersion
            };
        }
    };
});

require('confluence/module-exporter').safeRequire('confluence-link-browser/tinymce/editor_plugin_src', function(LinkBrowser) {
    var tinymce = require('tinymce');

    tinymce.create('tinymce.plugins.LinkBrowser', LinkBrowser);
    tinymce.PluginManager.add('linkbrowser', tinymce.plugins.LinkBrowser);
});

